% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_topology_stats.R
\name{calc_topology_stats}
\alias{calc_topology_stats}
\title{Calculate all topology based statistics for a single tree}
\usage{
calc_topology_stats(phylo, normalize = FALSE)
}
\arguments{
\item{phylo}{phylo object}

\item{normalize}{if set to TRUE, results are normalized (if possible) under
either the  Yule expectation (if available), or the number of tips}
}
\value{
list with statistics
}
\description{
this function calculates all tree statistics based on topology
available in this package for a single tree, being:
\itemize{
  \item{area_per_pair}
  \item{average_leaf_depth}
  \item{avg_ladder}
  \item{avg_vert_depth}
  \item{b1}
  \item{b2}
  \item{beta}
  \item{blum}
  \item{cherries}
  \item{colless}
  \item{colless_corr}
  \item{colless_quad}
  \item{diameter}
  \item{double_cherries}
  \item{eigen_centrality}
  \item{ew_colless}
  \item{four_prong}
  \item{i_stat}
  \item{il_number}
  \item{imbalance_steps}
  \item{j_one}
  \item{max_betweenness}
  \item{max_closeness}
  \item{max_del_width}
  \item{max_depth}
  \item{max_ladder}
  \item{max_width}
  \item{mw_over_md}
  \item{pitchforks}
  \item{rogers}
  \item{root_imbalance}
  \item{rquartet}
  \item{sackin}
  \item{stairs}
  \item{stairs2}
  \item{symmetry_nodes}
  \item{tot_coph}
  \item{tot_internal_path}
  \item{tot_path_length}
  \item{var_depth}
}
}
