% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_scores.R
\name{image_scores_dir}
\alias{image_scores_dir}
\title{Calculate image scores for all images in a directory (fast batch)}
\usage{
image_scores_dir(
  dir,
  classes,
  face_selection = "largest",
  pattern = "\\\\.(jpg|jpeg|png|bmp)$",
  recursive = FALSE,
  model = "oai-base",
  local_model_path = NULL
)
}
\arguments{
\item{dir}{Path to a directory containing images.}

\item{classes}{Character vector of labels/classes (length >= 2).}

\item{face_selection}{Face selection strategy: "largest", "left", "right", or "none".}

\item{pattern}{Optional regex to filter images (default supports common formats).}

\item{recursive}{Whether to search subdirectories (default FALSE).}

\item{model}{CLIP model alias or HuggingFace model id (see image_scores()).}

\item{local_model_path}{Optional local path to a pre-downloaded model.}
}
\value{
A data.frame with columns: image_id and one column per class.
}
\description{
This function scans a directory for image files and computes scores for each
image using a Hugging Face CLIP model. It loads the model once and reuses
text embeddings for speed, returning one row per image with the filename as
image_id and probability columns for each class.
}
