% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajReduce.R
\name{trajReduce}
\alias{trajReduce}
\title{Select a Subset of the Measures Using a Similarity Index on the Set of Clusterings}
\usage{
trajReduce(Measures, Clusters, index = "ARI", keep = 3)
}
\arguments{
\item{Measures}{object of class \code{trajMeasures} as returned by \code{\link[traj]{trajMeasures}}.}

\item{Clusters}{object of class \code{trajClusters} as returned by \code{\link[traj]{trajClusters}}.}

\item{index}{The similarity index. Either "ARI" for the Adjusted Rand Index of Hubert and Arabie (1985), "nVId" for the normalized variation of information distance (eg. Meila (2007)) or "nSJd" for the normalized split/joint distance of van Dongen (2000).}

\item{keep}{The number of measures to keep. Defaults to 3.}
}
\description{
This function examines the effect of reducing the number of measures on which the trajectories are clustered. Specifically, starting from a clustering \eqn{C} in the form of an object of class \code{trajClusters} and a choice of a similarity index to compare clusterings, this function finds the subset of measures which results in the clustering most similar to \eqn{C}.
}
\details{
The Rand index ranges from 0 to 1 with 0 indicating identical clusters and 1 indicating maximally different clusters. The normalized variation of information distance (nVId) and normalized split-join distance (nSJd) and have the opposite interpretation with 0 indicating maximally different clusters and 1 indicating identical clusters. Therefor, to facilitate comparison, we plot 1 - nVId (resp. 1 - nSJd) instead of nVId (resp. nSJd).
}
\examples{
\dontrun{
data("trajdata")
trajdata.noGrp <- trajdata[, -which(colnames(trajdata) == "Group")] #remove the Group column

m = trajMeasures(trajdata.noGrp, ID = TRUE)
trajReduce(m)
}

}
\references{
Hubert L, Arabie P. Comparing partitions. Journal of Classification 2:193-218, 1985.

Meila M. Comparing clusterings -- an information based distance. Journal of Multivariate Analysis, 98, pp 873-895, 2007.

van Dongen S. Performance criteria for graph clustering and Markov cluster experiments. Technical Report INS-R0012, National Research Institute for Mathematics and Computer Science in the Netherlands, Amsterdam, May 2000.
}
