% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_topics.R
\name{label_topics}
\alias{label_topics}
\alias{label_topics.default}
\alias{label_topics.labelTopics}
\title{Automatically label topics using language models based on top terms}
\usage{
label_topics(...)

\method{label_topics}{default}(
  terms,
  model = "google/gemma-2-2b-it",
  params = list(),
  token = NA_character_,
  context = "",
  sep_terms = "; ",
  max_length_label = 5L,
  prompt_type = c("json", "plain", "json-roles"),
  max_wait = 0L,
  progress = TRUE,
  ...
)

\method{label_topics}{labelTopics}(terms, stm_type = c("prob", "frex", "lift", "score"), ...)
}
\arguments{
\item{...}{additional arguments}

\item{terms}{[\code{list (k) of character}]\cr
List (each list entry represents one topic) of \code{character} vectors
containing the top terms representing the topics that are to be labeled.
If a single \code{character} vector is passed, this is interpreted as
the top terms of a single topic. If a \code{character} matrix is passed,
each column is interpreted as the top terms of a topic.
The outputs of the packages \code{stm} (\code{label_topics} object, please
specify the type of output using the parameter \code{stm_type}) and the
\code{BTM} package (\code{list} of \code{data.frame}s with entries
\code{token} and \code{probability} each) are also supported.}

\item{model}{[\code{character(1)}]\cr
Optional.\cr
The language model to use for labeling the topics.
The model must be accessible via the Huggingface API. Default is
\code{google/gemma-2-2b-it}. Another promising model is
\code{deepseek-ai/DeepSeek-V3.2-Exp:novita}.
To find more models see: https://huggingface.co/models?other=conversational&sort=likes.}

\item{params}{[\code{named list}]\cr
Optional.\cr
Model parameters to pass. Default parameters for common models are
given in the details section.}

\item{token}{[\code{character(1)}]\cr
Optional.\cr
If you want to address the Huggingface API with a Huggingface token, enter
it here. The main advantage of this is a higher rate limit.}

\item{context}{[\code{character(1)}]\cr
Optional.\cr
Explanatory context for the topics to be labeled. Using a (very) brief
explanation of the thematic context may greatly improve the usefulness of
automatically generated topic labels.}

\item{sep_terms}{[\code{character(1)}]\cr
How should the top terms of a single topic be separated in the generated
prompts? Default is separation via semicolon and space.}

\item{max_length_label}{[\code{integer(1)}]\cr
What is the maximum number of words a label should consist of? Default is five words.}

\item{prompt_type}{[\code{character(1)}]\cr
Which prompt type should be applied. We implemented various prompt types that
differ mainly in how the response of the language model is requested. Examples
are given in the details section. Default is the request of a json output.}

\item{max_wait}{[\code{integer(1)}]\cr
In the case that the rate limit on Huggingface is reached: How long
(in minutes) should the system wait until it asks the user whether
to continue (in other words: to wait). The default is zero minutes, i.e the
user is asked every time the rate limit is reached.}

\item{progress}{[\code{logical(1)}]\cr
Should a nice progress bar be shown? Turning it off, could lead to
significantly faster calculation. Default ist \code{TRUE}.}

\item{stm_type}{[\code{character(1)}]\cr
For stm topics, which type of word weighting should be used? Default is "prob".}
}
\value{
[\code{named list}] \code{\link[topiclabels:as.lm_topic_labels]{lm_topic_labels}} object.
}
\description{
Performs an automated labeling process of topics from topic models using
language models. For this, the top terms and (optionally) a short context
description are used.
}
\details{
The function builds helpful prompts based on the top terms and sends these
prompts to language models on Huggingface. The output is in turn
post-processed so that the labels for each topic are extracted automatically.
If the automatically extracted labels show any errors, they can alternatively
be extracted using custom functions or manually from the original output of
the model using the \code{model_output} entry of the lm_topic_labels object.

Implemented default parameters for the models \code{google/gemma-2-2b-it} and
\code{deepseek-ai/DeepSeek-V3.2-Exp:novita} are:
\describe{
  \item{\code{max_new_tokens}}{300}
  \item{\code{return_full_text}}{\code{FALSE}}
}

Implemented prompt types are:
\describe{
  \item{\code{json}}{the language model is asked to respond in JSON format
  with a single field called 'label', specifying the best label for the topic}
  \item{\code{plain}}{the language model is asked to return an answer that
  should only consist of the best label for the topic}
  \item{\code{json-roles}}{the language model is asked to respond in JSON format
  with a single field called 'label', specifying the best label for the topic;
  in addition, the model is queried using identifiers for <|user|> input and
  the beginning of the <|assistant|> output}
}
}
\examples{
\dontrun{
token = "" # please insert your hf token here
topwords_matrix = matrix(c("zidane", "figo", "kroos",
                           "gas", "power", "wind"), ncol = 2)
label_topics(topwords_matrix, token = token)
label_topics(list(c("zidane", "figo", "kroos"),
                  c("gas", "power", "wind")),
             token = token)
label_topics(list(c("zidane", "figo", "ronaldo"),
                  c("gas", "power", "wind")),
             token = token)

label_topics(list("wind", "greta", "hambach"),
             token = token)
label_topics(list("wind", "fire", "air"),
             token = token)
label_topics(list("wind", "feuer", "luft"),
             token = token)
label_topics(list("wind", "feuer", "luft"),
             context = "Elements of the Earth",
             token = token)
}
}
