% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_loess.R
\name{type_loess}
\alias{type_loess}
\title{Local polynomial regression plot type}
\usage{
type_loess(
  span = 0.75,
  degree = 2,
  family = "gaussian",
  control = loess.control(),
  se = TRUE,
  level = 0.95
)
}
\arguments{
\item{span}{the parameter \eqn{\alpha} which controls the degree of
    smoothing.}

\item{degree}{the degree of the polynomials to be used, normally 1 or
    2. (Degree 0 is also allowed, but see the \sQuote{Note}.)}

\item{family}{if \code{"gaussian"} fitting is by least-squares, and if
    \code{"symmetric"} a re-descending M estimator is used with Tukey's
    biweight function.  Can be abbreviated.}

\item{control}{control parameters: see \code{\link[stats]{loess.control}}.}

\item{se}{logical. If \code{TRUE} (the default), confidence intervals are drawn.}

\item{level}{the confidence level required if \code{se = TRUE}. Default is 0.95.}
}
\description{
Type function for plotting a LOESS (LOcal regrESSion) fit.
Arguments are passed to \code{\link[stats]{loess}}.
}
\examples{
# "loess" type convenience string
tinyplot(dist ~ speed, data = cars, type = "loess")

# Use `type_loess()` to pass extra arguments for customization
tinyplot(dist ~ speed, data = cars, type = type_loess(span = 0.5, degree = 1))
}
