% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-spatvector.R
\name{as_spatvector}
\alias{as_spatvector}
\alias{as_spatvector.data.frame}
\alias{as_spatvector.sf}
\alias{as_spatvector.sfc}
\alias{as_spatvector.SpatVector}
\title{Method for coercing objects to \code{SpatVector}}
\usage{
as_spatvector(x, ...)

\method{as_spatvector}{data.frame}(x, ..., geom = c("lon", "lat"), crs = "")

\method{as_spatvector}{sf}(x, ...)

\method{as_spatvector}{sfc}(x, ...)

\method{as_spatvector}{SpatVector}(x, ...)
}
\arguments{
\item{x}{A \link[tibble:tbl_df-class]{tibble}, data frame or \CRANpkg{sf} object of
class \code{\link[sf:sf]{sf}} or \code{\link[sf:sfc]{sfc}}.}

\item{...}{additional arguments passed on to \code{\link[terra:vect]{terra::vect()}}.}

\item{geom}{character. The field name(s) with the geometry data. Either
two names for x and y coordinates of points, or a single name for a single
column with WKT geometries.}

\item{crs}{A crs on several formats (PROJ.4, WKT, EPSG code, ..) or
and spatial object from \CRANpkg{sf} or \CRANpkg{terra} that includes the
target coordinate reference system. See \code{\link[=pull_crs]{pull_crs()}} and \strong{Details}.}
}
\value{
A \code{SpatVector}.
}
\description{
\code{as_spatvector()} turns an existing  object into a \code{SpatVector}. This is a
wrapper of \code{\link[terra:vect]{terra::vect()}} S4 method for signature \code{data.frame}.
}
\details{
This function differs from \code{\link[terra:vect]{terra::vect()}} on the following:
\itemize{
\item geometries with \code{NA} or \code{""} values are removed prior to conversion
\item If \code{x} is a grouped data frame (see \code{\link[dplyr:group_by]{dplyr::group_by()}}) the grouping
vars are transferred and a "grouped" \code{SpatVector} is created (see
\code{\link[=group_by.SpatVector]{group_by.SpatVector()}}).
\item If no \code{crs} is provided and the tibble has been created with the method
\code{\link[=as_tibble.SpatVector]{as_tibble.SpatVector()}}, the \code{crs} is inferred from
\code{\link[=attr]{attr(x, "crs")}}.
\item Handles correctly the conversion of \code{EMPTY} geometries between
\CRANpkg{sf} and \CRANpkg{terra}.
}
}
\section{\CRANpkg{terra} equivalent}{


\code{\link[terra:vect]{terra::vect()}}
}

\examples{
library(terra)

v <- vect(matrix(1:80, ncol = 2), crs = "EPSG:3857")

v$cat <- sample(LETTERS[1:4], size = nrow(v), replace = TRUE)

v

# Create tibble
as_tbl <- as_tibble(v, geom = "WKT")

as_tbl

# From tibble
newvect <- as_spatvector(as_tbl, geom = "geometry", crs = "EPSG:3857")
newvect

}
\seealso{
\code{\link[=pull_crs]{pull_crs()}} for retrieving crs, and the corresponding utils \code{\link[sf:st_crs]{sf::st_crs()}}
and \code{\link[terra:crs]{terra::crs()}}.

Coercing objects:
\code{\link{as_coordinates}()},
\code{\link{as_sf}()},
\code{\link{as_spatraster}()},
\code{\link{as_tibble.Spat}},
\code{\link{fortify.Spat}},
\code{\link{tidy.Spat}}
}
\concept{coerce}
