% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/answer_as_key_value.R
\name{answer_as_key_value}
\alias{answer_as_key_value}
\title{Make LLM answer as a list of key-value pairs}
\usage{
answer_as_key_value(
  prompt,
  key_name = "key",
  value_name = "value",
  pair_explanation = NULL,
  n_unique_items = NULL,
  list_mode = c("bullet", "comma")
)
}
\arguments{
\item{prompt}{A single string or a \code{\link[=tidyprompt]{tidyprompt()}} object}

\item{key_name}{(optional) A name or placeholder describing the "key" part
of each pair}

\item{value_name}{(optional) A name or placeholder describing the "value" part
of each pair}

\item{pair_explanation}{(optional) Additional explanation of what a pair should
be. It should be a single string. It will be appended after the list instruction.}

\item{n_unique_items}{(optional) Number of unique key-value pairs required in the list}

\item{list_mode}{(optional) Mode of the list: "bullet" or "comma".
\itemize{
\item "bullet" mode expects pairs like:

\if{html}{\out{<div class="sourceCode">}}\preformatted{-- key1: value1
-- key2: value2
}\if{html}{\out{</div>}}
\item "comma" mode expects pairs like:

\if{html}{\out{<div class="sourceCode">}}\preformatted{1. key: value, 2. key: value, etc.
}\if{html}{\out{</div>}}
}}
}
\value{
A \code{\link[=tidyprompt]{tidyprompt()}} with an added \code{\link[=prompt_wrap]{prompt_wrap()}} which
will ensure that the LLM response is a list of key-value pairs.
}
\description{
This function is similar to \code{answer_as_list()} but instead of returning
a list of items, it instructs the LLM to return a list of key-value pairs.
}
\examples{
\dontrun{
  "What are a few capital cities around the world?" |>
    answer_as_key_value(
      key_name = "country",
      value_name = "capital"
    ) |>
    send_prompt()
  # --- Sending request to LLM provider (llama3.1:8b): ---
  # What are a few capital cities around the world?
  #
  # Respond with a list of key-value pairs, like so:
  #   -- <<country 1>>: <<capital 1>>
  #   -- <<country 2>>: <<capital 2>>
  #   etc.
  # --- Receiving response from LLM provider: ---
  # Here are a few:
  #   -- Australia: Canberra
  #   -- France: Paris
  #   -- United States: Washington D.C.
  #   -- Japan: Tokyo
  #   -- China: Beijing
  # $Australia
  # [1] "Canberra"
  #
  # $France
  # [1] "Paris"
  #
  # $`United States`
  # [1] "Washington D.C."
  #
  # $Japan
  # [1] "Tokyo"
  #
  # $China
  # [1] "Beijing"
}
}
