% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_tibble.R
\name{gen_tibble}
\alias{gen_tibble}
\alias{gen_tibble.character}
\alias{gen_tibble.matrix}
\title{Constructor for a \code{gen_tibble}}
\usage{
gen_tibble(
  x,
  ...,
  valid_alleles = c("A", "T", "C", "G"),
  missing_alleles = c("0", "."),
  backingfile = NULL,
  allow_duplicates = FALSE,
  quiet = FALSE
)

\method{gen_tibble}{character}(
  x,
  ...,
  parser = c("cpp", "vcfR"),
  n_cores = 1,
  chunk_size = NULL,
  valid_alleles = c("A", "T", "C", "G"),
  missing_alleles = c("0", "."),
  backingfile = NULL,
  allow_duplicates = FALSE,
  quiet = FALSE
)

\method{gen_tibble}{matrix}(
  x,
  indiv_meta,
  loci,
  ...,
  ploidy = 2,
  valid_alleles = c("A", "T", "C", "G"),
  missing_alleles = c("0", "."),
  backingfile = NULL,
  allow_duplicates = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{x}{can be:
\itemize{
\item a string giving the path to a PLINK BED or PED file. The associated
BIM and FAM files for the BED, or MAP for PED are expected to be in the
same directory and have the same file name.
\item a string giving the path to a RDS file storing a \code{bigSNP} object from
the \code{bigsnpr} package (usually created with \code{\link[bigsnpr:snp_readBed]{bigsnpr::snp_readBed()}})
\item a string giving the path to a vcf file. Only biallelic SNPs will be
considered.
\item a string giving the path to a \emph{packedancestry} .geno file. The associated
.ind and .snp files are expected to be in the same directory and share the
same file name prefix.
\item a genotype matrix of dosages (0, 1, 2, NA) giving the dosage of the
alternate allele.
}}

\item{...}{if \code{x} is the name of a vcf file, additional arguments passed to
\code{\link[vcfR:io_vcfR]{vcfR::read.vcfR()}}. Otherwise, unused.}

\item{valid_alleles}{a vector of valid allele values; it defaults to 'A','T',
'C' and 'G'.}

\item{missing_alleles}{a vector of values in the BIM file/loci dataframe that
indicate a missing value for the allele value (e.g. when we have a
monomorphic locus with only one allele). It defaults to '0' and '.' (the
same as PLINK 1.9).}

\item{backingfile}{the path, including the file name without extension, for
backing files used to store the data (they will be given a .bk and .RDS
automatically). This is not needed if \code{x} is already an .RDS file. If \code{x}
is a .BED or a \emph{VCF} file and \code{backingfile} is left NULL, the backing file
will be saved in the same directory as the bed or vcf file, using the same
file name but with a different file type (.bk rather than .bed or .vcf). If
\code{x} is a genotype matrix and \code{backingfile} is NULL, then a temporary file
will be created (but note that R will delete it at the end of the session!)}

\item{allow_duplicates}{logical. If TRUE, the tibble will allow duplicated
loci (those with genomic coordinate (chromosome + position) or locus name
appearing more than once). If FALSE, an error will be thrown if duplicated
loci are found. These validations run before backing
files are saved. Default is FALSE.}

\item{quiet}{provide information on the files used to store the data}

\item{parser}{the name of the parser used for \emph{VCF}, either "cpp" to use a
fast C++ parser (the default), or "vcfR" to use the R package \code{vcfR}. The
latter is slower but more robust; if "cpp" gives an error, try using "vcfR"
in case your
\emph{VCF} has an unusual structure.}

\item{n_cores}{the number of cores to use for parallel processing}

\item{chunk_size}{the number of loci or individuals (depending on the format)
processed at a time (currently used if \code{x} is a vcf with parser "vcfR")}

\item{indiv_meta}{a list, data.frame or tibble with compulsory columns 'id'
and 'population', plus any additional metadata of interest. This is only
used if \code{x} is a genotype matrix. Otherwise this information is extracted
directly from the files.}

\item{loci}{a data.frame or tibble, with compulsory columns 'name',
'chromosome', and 'position','genetic_dist', 'allele_ref' and 'allele_alt'.
This is only used if \code{x} is a genotype matrix. Otherwise this information
is extracted directly from the files.}

\item{ploidy}{the ploidy of the samples (either a single value, or
a vector of values for mixed ploidy). Only used if creating
a gen_tibble from a matrix of data; otherwise, ploidy is determined
automatically from the data as they are read.}
}
\value{
an object of the class \code{gen_tbl}.
}
\description{
A \code{gen_tibble} stores genotypes for individuals in a tidy format. DESCRIBE
here the format
}
\details{
\itemize{
\item \emph{VCF} files: the fast \code{cpp} parser is used by default. Both \code{cpp} and
\code{vcfR} parsers attempt to establish ploidy from the first variant; if that
variant is found in a sex chromosome (or mtDNA), the parser will fail with
'Error: a genotype has more than max_ploidy alleles...'. To successful import
such a \emph{VCF}, change the order of variants so that the first chromosome is an
autosome using a tool such as \code{vcftools}. Currently, only biallelic SNPs are
supported. If haploid variants (e.g. sex chromosomes) are included in the
\emph{VCF}, they are not transformed into homozygous calls. Instead, reference
alleles will be coded as 0 and alternative alleles will be coded as 1.
\item \emph{packedancestry} files: When loading \emph{packedancestry} files,
missing alleles will be converted from 'X' to NA
}
}
\note{
Helper functions for accessing \code{gen_tibble} object attributes and
checking gen_tibble ploidy can be found in gt_helper_functions.R
}
\examples{
\dontshow{
data.table::setDTthreads(2)
RhpcBLASctl::blas_set_num_threads(2)
RhpcBLASctl::omp_set_num_threads(2)
}
# Create a gen_tibble from a .bed file
bed_file <-
  system.file("extdata", "lobster", "lobster.bed", package = "tidypopgen")
gen_tibble(bed_file,
  backingfile = tempfile("lobsters"),
  quiet = TRUE
)

# Create a gen_tibble from a .vcf file
vcf_path <-
  system.file("extdata", "anolis",
    "punctatus_t70_s10_n46_filtered.recode.vcf.gz",
    package = "tidypopgen"
  )
gen_tibble(vcf_path, quiet = TRUE, backingfile = tempfile("anolis_"))

# Create a gen_tibble from a matrix of genotypes:
test_indiv_meta <- data.frame(
  id = c("a", "b", "c"),
  population = c("pop1", "pop1", "pop2")
)
test_genotypes <- rbind(
  c(1, 1, 0, 1, 1, 0),
  c(2, 1, 0, 0, 0, 0),
  c(2, 2, 0, 0, 1, 1)
)
test_loci <- data.frame(
  name = paste0("rs", 1:6),
  chromosome = paste0("chr", c(1, 1, 1, 1, 2, 2)),
  position = as.integer(c(3, 5, 65, 343, 23, 456)),
  genetic_dist = as.double(rep(0, 6)),
  allele_ref = c("A", "T", "C", "G", "C", "T"),
  allele_alt = c("T", "C", NA, "C", "G", "A")
)

gen_tibble(
  x = test_genotypes,
  loci = test_loci,
  indiv_meta = test_indiv_meta,
  valid_alleles = c("A", "T", "C", "G"),
  quiet = TRUE
)

}
