% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supervised-deep-learning.R
\name{tl_tune_deep}
\alias{tl_tune_deep}
\title{Tune a deep learning model}
\usage{
tl_tune_deep(
  data,
  formula,
  is_classification = FALSE,
  hidden_layers_options = list(c(32), c(64, 32), c(128, 64, 32)),
  learning_rates = c(0.01, 0.001, 1e-04),
  batch_sizes = c(16, 32, 64),
  epochs = 30,
  validation_split = 0.2,
  ...
)
}
\arguments{
\item{data}{A data frame containing the training data}

\item{formula}{A formula specifying the model}

\item{is_classification}{Logical indicating if this is a classification problem}

\item{hidden_layers_options}{List of vectors defining hidden layer configurations to try}

\item{learning_rates}{Learning rates to try (default: c(0.01, 0.001, 0.0001))}

\item{batch_sizes}{Batch sizes to try (default: c(16, 32, 64))}

\item{epochs}{Number of training epochs (default: 30)}

\item{validation_split}{Proportion of data for validation (default: 0.2)}

\item{...}{Additional arguments}
}
\value{
A list with the best model and tuning results
}
\description{
Tune a deep learning model
}
