% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/various.R
\name{weighting}
\alias{weighting}
\title{Weighting Factors}
\usage{
weighting(
  x,
  method = c("linear-inverse", "inverse", "cosine", "none"),
  max.err = 90
)
}
\arguments{
\item{x}{numeric. Uncertainty angle in degrees.}

\item{method}{character. One of \code{"linear-inverse"} (the default), \code{"inverse"}, \code{"cosine"}, or \code{"none"} (no transformation).}

\item{max.err}{numeric. The maximum expected error for x (90 by default).}
}
\value{
numeric
}
\description{
Helper function to transform uncertainty angles into weighting factors
}
\details{
Linear inverse: \eqn{w = 1 - x/\sigma}, where \eqn{\sigma} is the maximum error expected for \eqn{x} (e.g. \eqn{90^\circ}).

Inverse: \eqn{w = 1/x}

Cosine: \eqn{w = \cos{x}}
}
\examples{
x <- seq(0, 90, 1)

plot(x, weighting(x, "inverse"),
  col = 1, type = "l",
  xlab = "Uncertainty angle in degrees", ylab = "weight"
)
lines(x, weighting(x, "cosine"), col = 2)
lines(x, weighting(x, "linear-inverse"), col = 3)
legend("topright",
  col = 1:3, lty = 1,
  legend = c("inverse", "cosine", "linear-inverse")
)
}
