% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mix_mod.R
\name{mix_mod}
\alias{mix_mod}
\title{Mixed model considering the effects of multiple covariates  .}
\usage{
mix_mod(data, Xcov)
}
\arguments{
\item{data}{Data matrix consisting of binary responses, i.e., 0s and 1s. Missing responses are NAs.}

\item{Xcov}{Covariate matrix. Persons in rows and covariates in columns, e.g., age, gender, drug dosage, etc. In case of
one covariate Xcov must be a one-column matrix.}
}
\value{
A list of class \code{tcl} with the following components:
  \item{CML_estimates}{Conditional maximum likelihood (CML) estimates of item (\eqn{\alpha} and \eqn{\delta})
 parameters (easiness, attractiveness). The effects of the first item are set to \eqn{0}
 for identifiability.}
  \item{SE}{Standard errors of CML estimates.}
  \item{Z_statistics}{Z test statistics for each single parameter (\eqn{\alpha} and \eqn{\delta}), i.e.,
  testing the hypothesis that the true value of the respective parameter is \eqn{0}
  against the alternative of \eqn{\neq 0}.}
  \item{pvalue}{A matrix of two-sided p-values for the \eqn{Z} tests.}
 \item{loglik}{Conditional log-likelihood.}
  \item{tests}{A table summarizing the results of four tests (W, LR, RS, GR) of the hypothesis that the effects of all covariates on all items are all 0.
  The table contains the test statistic (\code{stat}), degrees of freedom (\code{df}), and two-sided p-value (\code{pvalue}) for each test.}
  \item{information_criteria}{AIC, BIC}
  \item{call}{The matched call.}
}
\description{
Estimates and tests linear effects of multiple covariates on item parameters of the Rasch model (RM) simultaneously.
}
\details{
The underlying model is a mixed-effects logit model with random person effects and ﬁxed item and covariates effects, i.e.,

\deqn{
\log \frac{P(Y_{ij} = 1)}{1 - P(Y_{ij} = 1)}
  = \tau_i + \alpha_j + \sum_{p = 1}^q x_{ip} \delta_{jp}, \quad
  i = 1, \dots, n, \; j = 1, \dots, k, \; p = 1, \dots, q,
}
where \eqn{Y_{ij} \in \{0, 1\}}, \eqn{\tau_i} is a person parameter, \eqn{\alpha_j} is a baseline effect of item \eqn{j},
\eqn{\delta_{jp}} is an effect of covariate \eqn{p} on item \eqn{j}, and \eqn{x_{ip}} is a covariate
value observed for person \eqn{i} and covariate \eqn{p}. For identifiability, \eqn{\alpha_1 = 0}, \eqn{\delta_{1p} = 0 \;\forall p}.
Setting all \eqn{\delta} parameters (\eqn{\forall j, p}) to 0 yields the RM as a special case (with the \eqn{\alpha}s as the
item parameters of the RM).

The \eqn{\alpha} and \eqn{\delta} parameters are estimated using a conditional maximum likelihood (CML)
approach and four different tests based on the conditional likelihood and derived from asymptotic theory
are provided, i.e., likelihood ratio (LR), Rao score (RS), Wald (W), and gradient (GR) test.
The hypothesis of interest is \eqn{\delta_{jp} = 0 \;\forall j, p} against the alternative that at least one \eqn{\delta}
parameter is not equal to \eqn{0}.
Furthermore, \eqn{Z} test statistics (i.e., standard normal distribution when
the true effect of a covariate on an item is \eqn{0}) are computed for each item and covariate separately.
}
\examples{
\dontrun{
##### Rasch Model #####
dat <- eRm::raschdat3
x1 <- c(rep(0,250), rep(1,250))
x2 <- runif(500,min = 0, max = 1)
X <- cbind(x1,x2)

res <- mix_mod(data = dat, Xcov = X)
# $CML_estimates
#      1      2      3      4      5      6
# base 0 -0.596 -1.152 -1.804 -1.846 -2.353
# 1    0 -0.380 -0.403  0.072 -0.121 -0.452
# 2    0  0.814  0.780  0.612 -0.277  0.069
#
# $SE
#       1     2     3     4     5     6
# base NA 0.356 0.347 0.349 0.353 0.369
# 1    NA 0.314 0.303 0.301 0.307 0.320
# 2    NA 0.564 0.545 0.541 0.548 0.572
#
# $Z_statistics
#       1      2      3      4      5      6
# base NA -1.675 -3.320 -5.175 -5.223 -6.377
# 1    NA -1.210 -1.330  0.240 -0.396 -1.413
# 2    NA  1.443  1.431  1.132 -0.505  0.121
#
# $pvalue
#       1     2     3     4     5     6
# base NA 0.094 0.001 0.000 0.000 0.000
# 1    NA 0.226 0.183 0.810 0.692 0.158
# 2    NA 0.149 0.153 0.258 0.613 0.904
#
# $loglik
# [1] -993.8575
#
# $tests
#      stat df pvalue
# W  14.339 10  0.158
# LR 14.462 10  0.153
# RS 14.507 10  0.151
# GR 14.499 10  0.151
#
# $information_criteria
#           AIC      BIC
# [1,] 2007.715 2049.432
#
# $call
# mix_mod(data = dat, Xcov = X)
#
# attr(,"class")
# [1] "tcl"
}
}
\references{
{
Draxler, C., & Kurz, A. (2025). Testing measurement invariance in a conditional likelihood framework by considering
multiple covariates simultaneously. Behavior Research Methods, 57(1), 50.
}
}
\seealso{
\code{\link{invar_test}}, \code{\link{change_test}}, and \code{\link{LLTM_test}}.
}
\keyword{htest}
