% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot_diversity.R
\docType{methods}
\name{plot.DiversityIndex}
\alias{plot.DiversityIndex}
\alias{plot,DiversityIndex,missing-method}
\title{Diversity Plot}
\usage{
\S4method{plot}{DiversityIndex,missing}(
  x,
  log = "x",
  col.mean = "#DDAA33",
  col.interval = "#004488",
  lty.mean = "solid",
  lty.interval = "dashed",
  lwd.mean = 1,
  lwd.interval = 1,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  sub = NULL,
  ann = graphics::par("ann"),
  axes = TRUE,
  frame.plot = axes,
  panel.first = NULL,
  panel.last = NULL,
  ...
)
}
\arguments{
\item{x}{A \linkS4class{DiversityIndex} object to be plotted.}

\item{log}{A \code{\link{character}} string indicating which axes should be in log
scale. Defaults to \code{x}.}

\item{col.mean, col.interval}{A \code{\link{character}} string specifying the
color of the lines.}

\item{lty.mean, lty.interval}{A \code{\link{character}} string or \code{\link{numeric}}
value specifying the line types.}

\item{lwd.mean, lwd.interval}{A non-negative \code{\link{numeric}} value specifying
the line widths.}

\item{xlab, ylab}{A \code{\link{character}} vector giving the x and y axis labels.}

\item{main}{A \code{\link{character}} string giving a main title for the plot.}

\item{sub}{A \code{\link{character}} string giving a subtitle for the plot.}

\item{ann}{A \code{\link{logical}} scalar: should the default annotation (title and x,
y and z axis labels) appear on the plot?}

\item{axes}{A \code{\link{logical}} scalar: should axes be drawn on the plot?}

\item{frame.plot}{A \code{\link{logical}} scalar: should a box be drawn around the
plot?}

\item{panel.first}{An an \code{expression} to be evaluated after the plot axes are
set up but before any plotting takes place. This can be useful for drawing
background grids.}

\item{panel.last}{An \code{expression} to be evaluated after plotting has taken
place but before the axes, title and box are added.}

\item{...}{Further \link[graphics:par]{graphical parameters} to be passed to
\code{\link[graphics:points]{graphics::points()}}, particularly, \code{cex}, \code{col} and \code{pch}.}
}
\value{
\code{plot()} is called for its side-effects: it results in a graphic being
displayed (invisibly returns \code{x}).
}
\description{
Diversity Plot
}
\examples{
\donttest{
## Data from Conkey 1980, Kintigh 1989
data("cantabria")

## Assemblage diversity size comparison
## Warning: this may take a few seconds!
h <- heterogeneity(cantabria, method = "shannon")
h_sim <- simulate(h)
plot(h_sim)

r <- richness(cantabria, method = "observed")
r_sim <- simulate(r)
plot(r_sim)
}
}
\seealso{
Other diversity measures: 
\code{\link{diversity}()},
\code{\link{evenness}()},
\code{\link{heterogeneity}()},
\code{\link{occurrence}()},
\code{\link{plot.RarefactionIndex}()},
\code{\link{profiles}()},
\code{\link{rarefaction}()},
\code{\link{richness}()},
\code{\link{she}()},
\code{\link{similarity}()},
\code{\link{simulate}()},
\code{\link{turnover}()}
}
\author{
N. Frerebeau
}
\concept{diversity measures}
