% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idframe.R
\name{idfrd}
\alias{idfrd}
\title{S3 class constructor for storing frequency response data}
\usage{
idfrd(respData, freq, Ts, spec = NULL, covData = NULL, noiseCov = NULL)
}
\arguments{
\item{respData}{frequency response data. For SISO systems, supply a 
vector of frequency response values. For MIMO systems with Ny 
outputs and Nu inputs, supply an array of size c(Ny,Nu,Nw).}

\item{freq}{frequency points of the response}

\item{Ts}{sampling time of data}

\item{spec}{power spectra and cross spectra of the system 
output disturbances (noise). Supply an array of size (Ny,Ny,Nw)}

\item{covData}{response data covariance matrices. Supply an array
of size (Ny,Nu,Nw,2,2). covData[ky,ku,kw,,] is the covariance matrix
of respData[ky,ku,kw]}

\item{noiseCov}{power spectra variance. Supply an array of 
size (Ny,Ny,Nw)}
}
\value{
an idfrd object
}
\description{
S3 class constructor for storing frequency response data
}
\seealso{
\code{\link{plot.idfrd}} for generating bode plots, 
\code{\link{spa}} and \code{\link{etfe}} for estimating the 
frequency response given input/output data
}

