% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{sd_is_answered}
\alias{sd_is_answered}
\title{Check if a question is answered}
\usage{
sd_is_answered(question_id)
}
\arguments{
\item{question_id}{The ID of the question to check.}
}
\value{
A logical value: \code{TRUE} if the question is answered, \code{FALSE}
otherwise.
}
\description{
This function checks if a given question has been answered by the user.
For matrix questions, it checks if all sub-questions (rows) are answered.
}
\examples{
if (interactive()) {
  library(surveydown)

  # Use sd_is_answered() to conditionally execute code:
  # server <- function(input, output, session) {
  #   observe({
  #     if (sd_is_answered(input$age)) {
  #       message("Age question answered!")
  #     }
  #   })
  #   sd_server()
  # }

  # Find a working directory and start from a template:
  sd_create_survey(template = "default")
  # This creates survey.qmd and app.R - launch the survey using app.R
}

}
