% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.surv.R
\name{write.surv}
\alias{write.surv}
\title{write.surv}
\usage{
write.surv(object, file, sheet = NULL, what = "surv")
}
\arguments{
\item{object}{a summary.flexsurvreg object containing the survival curves
(with times, estimates and interval limits)}

\item{file}{a string with the full path to the file name to be saved}

\item{sheet}{a string with the name of the sheet to be created}

\item{what}{a string to describe what to be exported. Can either be
'surv' (default), which outputs the simulation(s) for the survival curves
or 'sim', which outputs the simulation(s) for the underlying model
parameters. If there are several 'profiles', they get written in
separate spreadsheets and a clear indication is given as the name of the
spreadsheet}
}
\value{
A spreadsheet file with the simulation(s) of the relevant quantity
}
\description{
Writes the survival summary to an excel file (helpful to then call the
values in the Markov model)
}
\details{
Something will go here
}
\examples{
\dontrun{
# Loads an example dataset from 'flexsurv'
data(bc)

# Fits the same model using the 3 inference methods
mle = fit.models(formula=Surv(recyrs,censrec)~group,data=bc,
    distr="exp",method="mle")
p.mle = make.surv(mle)
write.surv(p.mle,file="test.xlsx")
}
}
\references{
G Baio (2019). survHE: Survival analysis for health economic evaluation
and cost-effectiveness modelling. Journal of Statistical Software (2020). vol 95,
14, 1-47. \url{doi:10.18637/jss.v095.i14}
}
\seealso{
\code{make.surv}
}
\author{
Gianluca Baio
}
\keyword{Excel}
\keyword{PSA}
