## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----echo=TRUE, eval=FALSE----------------------------------------------------
# install.packages("survAH")

## ----echo=TRUE, eval=FALSE----------------------------------------------------
# install.packages("devtools") #-- if the devtools package has not been installed
# devtools::install_github("uno1lab/survAH")

## ----echo=TRUE, eval=TRUE, message=FALSE--------------------------------------
library(survAH)

nrow(cm214_pfs)

head(cm214_pfs)

## ----echo=FALSE, eval=TRUE, fig.height=6, fig.width=6-------------------------
library(survival)
plot(survfit(Surv(time, status)~arm, data=cm214_pfs), col=c("blue","red"), lwd=2, mark.time=F, xlab="Time (month)", ylab="Probability")
legend("bottomleft", c("Placebo (arm=0)","Treatment (arm=1)"), col=c("blue","red"), lwd=2)

## ----echo=TRUE, eval=TRUE-----------------------------------------------------
time   = cm214_pfs$time
status = cm214_pfs$status
arm    = cm214_pfs$arm

## ----echo=TRUE, eval=FALSE----------------------------------------------------
# ah2(time=time, status=status, arm=arm, tau=21)

## ----echo=TRUE, eval=FALSE----------------------------------------------------
# ah2(time, status, arm)

## ----echo=TRUE, eval=TRUE-----------------------------------------------------
obj = ah2(time, status, arm, tau=21)
print(obj, digits=3)

## ----echo=TRUE, eval=TRUE, message=FALSE--------------------------------------
nrow(myeloid)
head(myeloid)

# Create new analysis variables:
# - arm_num: binary treatment indicator (1 = arm B [treatment], 0 = arm A [control])
# - time_yr: follow-up time converted from days to years
myeloid$arm_num <- ifelse(myeloid$trt == "B", 1, 0)
myeloid$time_yr <- myeloid$futime / 365.25

## ----echo=FALSE, eval=TRUE, fig.height=6, fig.width=6-------------------------
# FLT3 = A
plot(survfit(Surv(time_yr, death) ~ trt, data = myeloid[myeloid$flt3 == "A", ]), col=c("blue","red"), lwd=2, mark.time=F, xlab="Time (year)", ylab="Probability", main = "Survival by Treatment Group (FLT3 = A)")
legend("bottomleft", c("Placebo (arm=0)","Treatment (arm=1)"), col=c("blue","red"), lwd=2)

## ----echo=FALSE, eval=TRUE, fig.height=6, fig.width=6-------------------------
# FLT3 = B
plot(survfit(Surv(time_yr, death) ~ trt, data = myeloid[myeloid$flt3 == "B", ]), col=c("blue","red"), lwd=2, mark.time=F, xlab="Time (year)", ylab="Probability", main = "Survival by Treatment Group (FLT3 = B)")
legend("bottomleft", c("Placebo (arm=0)","Treatment (arm=1)"), col=c("blue","red"), lwd=2)

## ----echo=FALSE, eval=TRUE, fig.height=6, fig.width=6-------------------------
# FLT3 = C
plot(survfit(Surv(time_yr, death) ~ trt, data = myeloid[myeloid$flt3 == "C", ]), col=c("blue","red"), lwd=2, mark.time=F, xlab="Time (year)", ylab="Probability", main = "Survival by Treatment Group (FLT3 = C)")
legend("bottomleft", c("Placebo (arm=0)","Treatment (arm=1)"), col=c("blue","red"), lwd=2)

## ----echo=TRUE, eval=TRUE-----------------------------------------------------
myel_time   = myeloid$time_yr
myel_status = myeloid$death
myel_arm <- ifelse(myeloid$trt == "B", 1, 0) # Convert treatment variable to binary: 1 = treatment (arm B), 0 = control (arm A)
myel_strata = myeloid$flt3

## ----echo=TRUE, eval=FALSE----------------------------------------------------
# ah2(time = myel_time,
#     status = myel_status,
#     arm = myel_arm,
#     tau = 3,
#     strata = myel_strata)
# 

## ----echo=TRUE, eval=TRUE-----------------------------------------------------

myel_obj <- ah2(time = myel_time,
                status = myel_status,
                arm = myel_arm,
                tau = 3,
                strata = myel_strata)

print(myel_obj,digit = 3)

## ----echo=TRUE, eval=TRUE, message=FALSE--------------------------------------
D = ahreg.sample.data()
nrow(D)
head(D)

## ----echo=FALSE, eval=TRUE, fig.height=7, fig.width=7-------------------------
plot(survfit(Surv(time, status)~arm, data=D), col=c("blue","red"), lwd=2, mark.time=F, xlab="Years", ylab="Probability")
legend("bottomleft", c("Placebo (arm=0)", "D-penicillamine (arm=1)"), col=c("blue", "red"), lwd=2)

## ----echo=TRUE, eval=TRUE-----------------------------------------------------
a1 <- ahreg(Surv(time, status) ~ arm + edema + bili, 
            tau  = 7, 
            data = D)

## ----echo=TRUE, eval=TRUE-----------------------------------------------------
print(a1, digits=3)

## ----echo=TRUE, eval=TRUE-----------------------------------------------------
a2 = ahreg(Surv(time, status) ~ arm + edema + bili,
           tau         = 7,
           data        = D,
           cens_strata = "arm")

## ----echo=TRUE, eval=TRUE-----------------------------------------------------
print(a2, digits = 3)

## ----echo=TRUE, eval=TRUE-----------------------------------------------------
a3 <- ahreg(Surv(time, status) ~ arm + edema + bili,
            tau       = 7,
            data      = D,
            cens_covs = c("arm", "edema"))

## ----echo=TRUE, eval=TRUE-----------------------------------------------------
print(a3, digits = 3)

## ----echo=TRUE, eval=TRUE-----------------------------------------------------
a4 <- ahreg(Surv(time, status) ~ arm + edema + bili,
            tau       = 7,
            data      = D,
            cens_covs = c("arm", "edema"),
            link      = "identity")

## ----echo=TRUE, eval=TRUE-----------------------------------------------------
print(a4, digits = 3)

