% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{size.test.mean}
\alias{size.test.mean}
\title{Sample size for a test of a mean}
\usage{
size.test.mean(alpha, pow, var, es)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{pow}{desired power}

\item{var}{planning value of response variable variance}

\item{es}{planning value of mean minus null hypothesis value}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to test a single population mean with
desired power in a 1-group design. Set the variance planning value to the
largest value within a plausible range for a conservatively large sample
size.

For more details, see Section 1.29 of Bonett (2021, Volume 1)
}
\examples{
size.test.mean(.05, .9, 8.2, 1.5)

# Should return:
# Sample size
#          41
 

}
\references{
\insertRef{Bonett2021}{statpsych}
}
