% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals_test.R
\name{residuals_test}
\alias{residuals_test}
\title{Normality test of a numeric vector}
\usage{
residuals_test(residuals)
}
\arguments{
\item{residuals}{Numeric vector, model residuals.}
}
\value{
A list with four slots:
\itemize{
/item \code{w} W statistic returned by \code{\link[=shapiro.test]{shapiro.test()}}.
/item \code{p.value} p-value of the Shapiro test.
/item \code{interpretation} Character vector, one of "x is normal", "x is not normal".
/item \code{plot} A patchwork plot with the qq plot and the histogram of x.
}
}
\description{
Applies a Shapiro-Wilks test to a numeric vector, and returns a list with the statistic W, its p-value, and a character string with the interpretation.
}
\examples{

residuals_test(residuals = runif(100))

}
\seealso{
Other spatial_analysis: 
\code{\link{filter_spatial_predictors}()},
\code{\link{mem}()},
\code{\link{mem_multithreshold}()},
\code{\link{moran}()},
\code{\link{moran_multithreshold}()},
\code{\link{pca}()},
\code{\link{pca_multithreshold}()},
\code{\link{rank_spatial_predictors}()},
\code{\link{residuals_diagnostics}()},
\code{\link{select_spatial_predictors_recursive}()},
\code{\link{select_spatial_predictors_sequential}()}
}
\concept{spatial_analysis}
