% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptfamily.R
\name{ptfamily}
\alias{ptfamily}
\title{Truncated Poisson Family for GLM}
\usage{
ptfamily(link = "log")
}
\arguments{
\item{link}{Character string or a link-glm object specifying the link function. Accepted values are "log", "identity", and "sqrt".}
}
\value{
An object of class "family" that can be used in \code{glm()}.
}
\description{
This function defines a truncated Poisson family for use in Generalized Linear Models (GLMs), 
where zero values are not allowed. It modifies the Poisson likelihood by excluding zero-count observations.
}
\examples{
set.seed(123)
y <- rpois(100, lambda = 3)
y <- y[y > 0]  # Truncate zeros
x <- rnorm(length(y))
model <- glm(y ~ x, family = ptfamily())
summary(model)

}
