% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocode_cadastral.R
\name{geocode_cadastral}
\alias{geocode_cadastral}
\title{geocode by longitude and latitude from cadastral references.}
\arguments{
\item{x}{A valid spanish cadastral reference.}

\item{parse_files}{bool. Default to FALSE. Set TRUE if source are KML files.}
}
\value{
A string for longitude/latitude if found. NA if not found.
}
\description{
Get longitude/latitude from valid cadastral ref. or kml files from catastro.
}
\section{Warning}{
 You may be banned if many requests in short time are made.
}

\examples{
## source is cadastral reference number ##
\dontrun{
## geocode_cadastral("0636105UF3403N", parse_files = FALSE)

##"36.5209422288168,-4.89298751473745"

## Use lapply to geocode cadastral references from dataframe columns.

cadastral_references$new <- lapply(cadastral_references$cadref1, geocode_cadastral)

## separate previously generated "new" data into columns usign tidyr

# library(tidyr)
# separate(cadastral_references, new, into = c('longitude','latitude'), sep = "," )

## source is folder. A loop is needed to process each kml file ##

# files <- list.files("folder", full.names = T)

# for (f in files) {
#  coords <- geocode_cadastral(f, parse_files = TRUE)
# d <- as.data.frame(rbind(d , as.data.frame(coords, stringsAsFactors = F )))
# }

# separate lat/lon into columns if you prefer using tidyr
# d <- tidyr::separate(coords, into = c("longitude","latitude"), sep = "," )
}
}
\keyword{cadastral}
\keyword{cadastre,}
\keyword{geocoding,}
\keyword{latitude,}
\keyword{longitude,}
\keyword{reference.}
