% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opmds.R
\name{opmds}
\alias{opmds}
\title{Nonlinear ratio MDS with optimal power of dissimilarities}
\usage{
opmds(
  delta,
  type = "ratio",
  weightmat = 1 - diag(nrow(delta)),
  init = NULL,
  ndim = 2,
  itmax = 1000,
  acc = 1e-10,
  verbose = FALSE,
  principal = FALSE,
  interval = c(0, 4)
)
}
\arguments{
\item{delta}{dist object or a symmetric, numeric data.frame or matrix of distances}

\item{type}{what type of MDS to fit. Currently only "ratio".}

\item{weightmat}{a matrix of finite weights.}

\item{init}{starting configuration}

\item{ndim}{dimension of the configuration; defaults to 2}

\item{itmax}{maximum number of iterations. Default is 10000.}

\item{acc}{numeric accuracy of the iteration. Default is 1e-6.}

\item{verbose}{should iteration output be printed; defaults to 'FALSE'.}

\item{principal}{If 'TRUE', principal axis transformation is applied to the final configuration.}

\item{interval}{the line constraints c(upper, lower), within which to look for the optimal power transformation lambda. Defaults to c(0,4).}
}
\value{
a 'smacofP' object (inheriting from 'smacofB', see \code{\link[smacof]{smacofSym}}). It is a list with the components
\itemize{
\item delta: Observed, untransformed dissimilarities
\item tdelta: Observed explicitly transformed dissimilarities, normalized
\item dhat: Explicitly transformed dissimilarities (dhats), optimally scaled and normalized 
\item confdist: Transformed fitted configuration distances
\item iord: optimal scaling ordering
\item conf: Matrix of fitted configuration
\item stress: Default stress  (stress 1; sqrt of explicitly normalized stress)
\item spp: Stress per point 
\item ndim: Number of dimensions
\item model: Name of smacof model
\item niter: Number of iterations
\item nobj: Number of objects
\item type: Type of MDS model
\item weightmat: weighting matrix as supplied
\item stress.m: Default stress (stress-1^2)
\item tweightmat: transformed weighting matrix (here NULL)
\item pars, theta: The optimal transformation parameter lambda
}
}
\description{
An implementation to minimize explicitly normalized stress over dissimilarities to a power by majorization with ratio optimal scaling in an alternating minimization algorithm. The optimal power transformation lambda of the dissimilarities is found by an inner optimization step via the Brent-Dekker method.
}
\examples{
dis<-smacof::kinshipdelta
res<-opmds(dis,itmax=1000)
res
summary(res)
plot(res)

}
\seealso{
See \code{\link[stops]{stops}} for a similar, more flexible idea.
}
