% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dissoc_power.R
\name{BSDT_cov_power}
\alias{BSDT_cov_power}
\title{Power calculator for BSDT_cov}
\usage{
BSDT_cov_power(
  case_tasks,
  case_cov,
  control_tasks = matrix(c(0, 0, 1, 1), ncol = 2),
  control_covar = c(0, 1),
  cor_mat = diag(3) + 0.3 - diag(c(0.3, 0.3, 0.3)),
  sample_size,
  alternative = c("two.sided", "greater", "less"),
  alpha = 0.05,
  nsim = 1000,
  iter = 1000,
  calibrated = TRUE
)
}
\arguments{
\item{case_tasks}{A vector of length 2. The expected case scores from the
tasks of interest.}

\item{case_cov}{A vector containing the expected case scores on all
covariates included.}

\item{control_tasks}{A 2x2 matrix or dataframe containing the expected means
(first column) and standard deviations (second column). Defaults to two
variables with means 0 and sd = 1.}

\item{control_covar}{A px2 matrix or dataframe containing the expected means
(first column) and standard deviations (second column), p being the number
of covariates. Defaults to one covariate with mean 0 and sd = 1.}

\item{cor_mat}{A correlation matrix containing the correlations of the tasks
of interest and the coviariate(s). The first two variables are treated as
the tasks of interest. Defaults pairwise correlations between the variates of 0.3.}

\item{sample_size}{Single value giving the size of the control sample for which you wish
to calculate power.}

\item{alternative}{The alternative hypothesis. A string of either "less",
"greater" or "two.sided" (default).}

\item{alpha}{The specified Type I error rate, default is 0.05. This can be
varied, with effects on power.}

\item{nsim}{The number of simulations for the power calculation. Defaults to
1000 due to BSDT already being computationally intense. Increase for better
accuracy.}

\item{iter}{The number of simulations used by the BSDT_cov, defaults to 1000.
Increase for better accuracy.}

\item{calibrated}{Whether or not to use the standard theory (Jeffreys) prior
distribution (if set to \code{FALSE}) or a calibrated prior. See Crawford
et al. (2011) for further information. Calibrated prior is recommended.}
}
\value{
Returns a single value approximating the power of the test for the
  given parameters.
}
\description{
Computationally intense. Lower \code{iter} and/or \code{nsim} for faster but
less precise calculations. Calculates approximate power, given sample size,
using Monte Carlo simulation for BSDT with covariates
for specified (expected) case score, means and standard deviations for the
control sample on the task of interest and included covariates. The number of
covariates defaults to 1, means and standard deviations for the tasks and
covariate default to 0 and 1, so if no other values are given the case scores
is interpreted as deviation from the mean in standard deviations for both tasks
and covariates.
}
\examples{
BSDT_cov_power(c(-2, 0), case_cov = c(0, 0, 0),
control_covar = matrix(c(0, 0, 0, 1, 1, 1), ncol= 2),
sample_size = 10, cor_mat = diag(5), iter = 20, nsim = 20)
}
