% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow.R
\name{MRPWorkflow-method-create_model}
\alias{MRPWorkflow-method-create_model}
\alias{create_model}
\title{Create a new MRPModel object}
\usage{
create_model(
  intercept_prior = NULL,
  fixed = NULL,
  varying = NULL,
  interaction = NULL,
  sens = 1,
  spec = 1
)
}
\arguments{
\item{intercept_prior}{Character string specifying the prior distribution for the overall intercept.
Check \emph{Details} for more information about prior specification.}

\item{fixed}{List of the fixed effects in the model and their prior distributions.
Check \emph{Details} for more information about prior specification.}

\item{varying}{List of the varying effects in the model and the prior distributions of their standard deviations.
Check \emph{Details} for more information about prior specification.}

\item{interaction}{List of the interactions in the model and their prior distributions. Interaction names are
created by concatenating the names of the interacting variables with a colon (e.g., "sex:age"). Currently,
only two-way interactions are supported. Check \emph{Details} for more information about prior specification.}

\item{sens}{Sensitivity adjustment in the COVID-19 test results. Check \emph{Details} for more information.}

\item{spec}{Specificity adjustment in the COVID-19 test results. Check \emph{Details} for more information.}
}
\value{
A new MRPModel object.
}
\description{
The \verb{$create_model()} method creates a new MRPModel object
with Stan code generated from the model specification list.
CmdStanR objects are used internally to interface with Stan to
compile the code and run its MCMC algorithm. Check out the
\href{https://mrp-interface.github.io/shinymrp/articles/example#create_model}{More examples of R6 classes}
vignette for usage examples.
}
\details{
\subsection{Prior specification}{

The syntax for the prior distributions is similar to that of Stan. The following are currently supported:
\itemize{
\item normal(mu, sigma)
\item student_t(nu, mu, sigma)
\item structured
\item icar
\item bym2
}

The structured prior distribution developed by \href{https://arxiv.org/abs/1707.08220}{Si et al. (2020)}, which can be assigned to three types of two-way interactions:
\itemize{
\item Two categorical variables (both with more than two levels)
\item One categorical variable (with more than two levels) and one binary variable
\item One categorical variable (with more than two levels) and one continuous variable
}

The spatial prior options (ICAR and BYM2) are useful when data contain geographic units (e.g., ZIP codes, counties, states) with spatial structure, specifically when observations exhibit correlation among neighboring regions. For details about the implementation and usage, see \href{https://mrp-interface.github.io/shinymrp/articles/spatial-prior.html}{Spatial prior specification in shinymrp}.

The following default prior distributions are assigned to effects with empty strings (\code{""})
in the model specification list:
\itemize{
\item Overall intercept: normal(0,5)
\item Coefficient: normal(0,3)
}

The model assumes varying effects follow a normal distribution with an unknown standard deviation, which will be assigned with priors.
\itemize{
\item Standard deviation (main effect): normal\if{html}{\out{<sub>}}+\if{html}{\out{</sub>}}(0,3)
\item Standard deviation (interaction): normal\if{html}{\out{<sub>}}+\if{html}{\out{</sub>}}(0,1)
}
}

\subsection{Testing sensitivity and specificity}{

For COVID data, we allow users to specify the PCR testing sensitivity and specificity. Let \eqn{p_k} be the probability
that person \eqn{i} in group \eqn{k} tests positive. The analytic incidence \eqn{p_k} is a function of the test sensitivity \eqn{\delta},
specificity \eqn{\gamma}, and the true incidence \eqn{\pi_k} for individuals in group \eqn{k}:
\deqn{p_k=(1-\gamma)(1-\pi_k )+\delta \pi_k.}
}
}
