% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentencepiece.R
\name{sentencepiece_load_model}
\alias{sentencepiece_load_model}
\title{Load a Sentencepiece model}
\usage{
sentencepiece_load_model(file = "sentencepiece.model")
}
\arguments{
\item{file}{path to the file containing the Sentencepiece model}
}
\value{
an object of class \code{sentencepiece} which is a list with elements
\itemize{
\item{model: an Rcpp pointer to the model}
\item{model_path: the path to the model}
\item{vocab_size: the size of the Sentencepiece vocabulary}
\item{vocabulary: the Sentencepiece vocabulary which is a data.frame with columns id and subword}
}
}
\description{
Load a Sentencepiece model which either was trained with \code{\link{sentencepiece}} or which you have found in the wild.
}
\examples{
model <- system.file(package = "sentencepiece", "models", "nl-fr-dekamer.model")
model <- sentencepiece_load_model(file = model)

txt <- c("De eigendomsoverdracht aan de deelstaten is ingewikkeld.",
         "On est d'accord sur le prix de la biere?")
sentencepiece_encode(model, x = txt, type = "subwords")
sentencepiece_encode(model, x = txt, type = "ids")
}
