% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_demographics.R
\name{st_demographics}
\alias{st_demographics}
\title{Fetch Demographics Data for Apps}
\usage{
st_demographics(
  unified_app_id = NULL,
  ios_app_id = NULL,
  android_app_id = NULL,
  os = NULL,
  country = "US",
  date_granularity = "all_time",
  start_date = NULL,
  end_date = NULL,
  auth_token = NULL,
  verbose = TRUE
)
}
\arguments{
\item{unified_app_id}{Character string. Sensor Tower unified app ID (24-character hex).
Will be resolved to platform-specific IDs automatically.}

\item{ios_app_id}{Character string. iOS app ID (numeric, e.g., "1234567890").}

\item{android_app_id}{Character string. Android package name (e.g., "com.example.app").}

\item{os}{Character string. Operating system: "ios" or "android". Required if using
platform-specific IDs. When using unified_app_id, defaults to trying both platforms.}

\item{country}{Character string. Country code (e.g., "US", "GB"). Default is "US".
Only single country supported per request.}

\item{date_granularity}{Character string. Either "all_time" (default) or "quarterly".
All-time data goes back to Q4 2015. Quarterly data begins Q1 2021.}

\item{start_date}{Date or character string. Start date for quarterly data in "YYYY-MM-DD" format.
Ignored for all_time granularity.}

\item{end_date}{Date or character string. End date for quarterly data in "YYYY-MM-DD" format.
Ignored for all_time granularity.}

\item{auth_token}{Optional. Character string. Your Sensor Tower API token.
Defaults to environment variable SENSORTOWER_AUTH_TOKEN.}

\item{verbose}{Logical. If TRUE, prints progress messages.}
}
\value{
A [tibble][tibble::tibble] with demographics metrics including:
  - **app_id**: The platform-specific app ID
  - **os**: Platform (ios or android)
  - **country**: Country code
  - **female_percent**: Percentage of female users (0-100)
  - **male_percent**: Percentage of male users (0-100)
  - **average_age**: Average user age
  - **age_13_17**, **age_18_24**, **age_25_34**, **age_35_44**, **age_45_54**,
    **age_55_64**, **age_65_plus**: Age group percentages
  - **confidence**: Data confidence level
}
\description{
Retrieves user demographics (age and gender breakdown) for specific apps from
the Sensor Tower Usage Intelligence API. This function queries the demographics
endpoint directly using platform-specific app IDs.
}
\section{Data Availability}{

- Quarterly data begins Q1 2021
- All-time data goes back to Q4 2015
- Demographics are primarily available for US market
- Data availability depends on app's user base size
}

\section{Recommended Workflow}{

```
# Step 1: Search for app by name
app <- st_app_info("Royal Match")

# Step 2: Get demographics using unified ID
demographics <- st_demographics(unified_app_id = app$unified_app_id[1])
```
}

\examples{
\dontrun{
# Get demographics for an app using unified ID
demo <- st_demographics(unified_app_id = "5f16a8019f7b275235017614")

# Get demographics for iOS app directly
demo <- st_demographics(
  ios_app_id = "553834731",
  os = "ios",
  country = "US"
)
}

}
\seealso{
[st_app_info()] for searching apps by name,
  [st_app_lookup()] for resolving app IDs,
  [st_retention()] for retention metrics
}
