% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orders.R
\name{schwab_replaceOrder}
\alias{schwab_replaceOrder}
\title{Replace a Specific Order based on Account and OrderID}
\usage{
schwab_replaceOrder(
  account_number,
  orderId,
  ticker,
  quantity,
  instruction,
  orderType = "MARKET",
  limitPrice = NULL,
  stopPrice = NULL,
  assetType = c("EQUITY", "OPTION"),
  session = "NORMAL",
  duration = "DAY",
  stopPriceBasis = NULL,
  stopPriceType = NULL,
  stopPriceOffset = NULL,
  accessTokenList = NULL
)
}
\arguments{
\item{account_number}{A Schwab account number associated with the Access Token}

\item{orderId}{The orderId of a currently open order}

\item{ticker}{a valid Equity/ETF or option. If needed, use schwab_symbolDetail to
confirm. This should be a ticker/symbol, not a CUSIP}

\item{quantity}{the number of shares to be bought or sold. Must be an
integer.}

\item{instruction}{Equity instructions include 'BUY', 'SELL', 'BUY_TO_COVER',
or 'SELL_SHORT'. Options instructions include 'BUY_TO_OPEN',
'BUY_TO_CLOSE', 'SELL_TO_OPEN', or 'SELL_TO_CLOSE'}

\item{orderType}{MARKET, LIMIT (requiring limitPrice), STOP (requiring
stopPrice), STOP_LIMIT, TRAILING_STOP (requiring stopPriceBasis,
stopPriceType, stopPriceOffset)}

\item{limitPrice}{the limit price for a LIMIT or STOP_LIMIT order}

\item{stopPrice}{the stop price for a STOP or STOP_LIMIT order}

\item{assetType}{EQUITY or OPTION. No other asset types are available at this
time. EQUITY is the default.}

\item{session}{NORMAL for normal market hours, AM or PM for extended market
hours}

\item{duration}{how long will the trade stay open without a fill: DAY,
GOOD_TILL_CANCEL, FILL_OR_KILL}

\item{stopPriceBasis}{LAST, BID, or ASK which is the basis for a STOP,
STOP_LIMIT, or TRAILING_STOP}

\item{stopPriceType}{the link to the stopPriceBasis. VALUE for dollar
difference or PERCENT for a percentage offset from the price basis}

\item{stopPriceOffset}{an integer that indicates the offset used for the
stopPriceType, 10 and PERCENT is a 10 percent offset from the current price
basis. 5 and VALUE is a 5 dollar offset from the current price basis}

\item{accessTokenList}{A valid Access Token must be set using the output from
\code{\link{schwab_auth3_accessToken}}. The most recent Access Token will be
used by default unless one is manually passed into the function.}
}
\value{
the trade id, account id, and other order details
}
\description{
Replace trades through the SchwabAPI using a range of parameters
}
\details{
This function will have similar inputs as \code{\link{schwab_placeOrder}}.
Please see that function for more details.

The replace order function requires an open orderId as an input.
This function requires the same ticker and direction as the previous order.
This function will generate a new orderId and cancel the old orderId.
}
\section{Warning}{
 TRADES THAT ARE SUCCESSFULLY ENTERED WILL BE SUBMITTED
  IMMEDIATELY THERE IS NO REVIEW PROCESS. THIS FUNCTION HAS HUNDREDS OF
  POTENTIAL COMBINATIONS AND ONLY A HANDFUL HAVE BEEN TESTED. IT IS STRONGLY
  RECOMMENDED TO TEST THE DESIRED ORDER ON A VERY SMALL QUANTITY WITH LITTLE
  MONEY AT STAKE. ANOTHER OPTION IS TO USE LIMIT ORDERS FAR FROM THE CURRENT
  PRICE. TD AMERITRADE HAS THEIR OWN ERROR HANDLING BUT IF A SUCCESSFUL
  COMBINATION IS ENTERED IT COULD BE EXECUTED IMMEDIATELY. DOUBLE CHECK ALL
  ENTRIES BEFORE SUBMITTING.
}

\examples{
\dontrun{

# Get stored refresh token
refreshToken = readRDS('/secure/location/')

# generate a new access token
accessTokenList = schwab_auth3_accessToken('AppKey', 'AppSecret', refreshToken)

# Set Account Number
account_number = 1234567890

# Place order
buy_order = schwab_placeOrder(account_number = account_number,
                             ticker = 'SPY',
                             quantity = 1,
                             orderType = 'LIMIT',
                             limitPrice = 500,
                             instruction = 'buy')

# This will generate a new order ID
repl_order = schwab_replaceOrder(account_number = account_number,
                                 orderId = buy_order$orderId[1],
                                 ticker = 'SPY',
                                 quantity = 1,
                                 orderType = 'LIMIT',
                                 limitPrice = 505,
                                 instruction = 'buy')


}
}
