% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_distribution.R
\name{build_target_hist}
\alias{build_target_hist}
\title{Function to obtain the target histogram from a vector of fire size data}
\usage{
build_target_hist(num_bins = 20, logaritmic = TRUE, sizes, event_surfaces)
}
\arguments{
\item{num_bins}{Integer. The desired number of bins for the histogram (default: 20).}

\item{logaritmic}{Logical. If `TRUE`, a logarithmic transformation (`log(sizes + 1e-6)`)
is applied to `sizes`. If `FALSE`, the original scale is used. This parameter
influences both the distribution transformation and the binning.}

\item{sizes}{Numeric vector. The fire sizes (e.g., area in hectares) from the
data used to build the target distribution.}

\item{event_surfaces}{Numeric vector. The fire sizes (e.g., area in hectares) from the
simulated fire perimeters.}
}
\value{
A list containing two elements:
  \describe{
    \item{target_hist}{A numeric vector representing the density values of the target histogram.}
    \item{bins}{A numeric vector specifying the breakpoints (edges) of the bins used in the histogram.}
  }
}
\description{
This function builds a histogram (specifically, its density) from a set of
fire sizes, which is intended to represent a target distribution (e.g., from
historical fire events). It allows for an optional logarithmic transformation
of the fire sizes before binning and determines bin breakpoints dynamically.
}
\examples{
# Dummy data for demonstration (replace with your actual data)
set.seed(123)
historical_data_for_target <- floor(fit_powerlaw(n = 500, alpha = 2, xmin = 10, xmax = 10000))
event_surfaces <- fit_powerlaw(n = 10000, alpha = 2, xmin = 10, xmax = 10000)

# Discard simulated fires that are too large (below 110\% max historical size)
event_surfaces <- event_surfaces[event_surfaces < max(historical_data_for_target) * 1.1]

# Default configuration: logaritmic transformation on fire size
target_info_example <- build_target_hist(num_bins = 10, logaritmic = TRUE,
                                         sizes = historical_data_for_target,
                                         event_surfaces = event_surfaces)

# Print results
target_hist <- target_info_example$target_hist
print(target_hist)
bins <- target_info_example$bins
print(bins)

# Alternate configuration: original frequency distribution on fire size
target_info_example <- build_target_hist(num_bins = 10, logaritmic = FALSE,
                                         sizes = historical_data_for_target,
                                         event_surfaces = event_surfaces)

# Print results
target_hist <- target_info_example$target_hist
print(target_hist)
bins <- target_info_example$bins
print(bins)
}
