% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extend_21_03_03.R
\name{rpms_boost}
\alias{rpms_boost}
\title{rpms_boost}
\usage{
rpms_boost(
  rp_equ,
  data,
  weights = ~1,
  strata = ~1,
  clusters = ~1,
  e_equ = ~1,
  bin_size = NULL,
  gridpts = 3,
  perm_reps = 100L,
  pval = 0.05,
  f_size = 200L,
  model_type = "tree",
  times = 2L
)
}
\arguments{
\item{rp_equ}{formula containing all variables for partitioning}

\item{data}{data.frame that includes variables used in rp_equ, e_equ, 
and design information}

\item{weights}{formula or vector of sample weights for each observation}

\item{strata}{formula or vector of strata labels}

\item{clusters}{formula or vector of cluster labels}

\item{e_equ}{formula for modeling data in each node}

\item{bin_size}{numeric minimum number of observations in each node}

\item{gridpts}{integer number of middle points to do in search}

\item{perm_reps}{integer specifying the number of thousands of permuation 
replications to use to estimate p-value}

\item{pval}{numeric p-value used to reject null hypothesis in permutation 
test}

\item{f_size}{integer specifying the number of trees in the forest (only used 
if model_type is "forest")}

\item{model_type}{string: one of "tree" or "forest"}

\item{times}{integer specifying number of boosting levels to try.}
}
\value{
object of class "rpms_boost"
}
\description{
function for producing boosted rpms models (trees or random forests)
}
\examples{
{
# model mean of retirement contributions with a binary tree while accounting 
# for clusterd data and sample weights.

rpms_boost(IRAX~EDUCA+AGE+BLS_URBN, data = CE,  weights=~FINLWT21, clusters=~CID, pval=.01)


}
}
