% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rofanova-package.R
\docType{package}
\name{rofanova-package}
\alias{rofanova-package}
\title{Robust Functional Analysis of Variance}
\description{
Implements the robust functional analysis of variance (RoFANOVA), described in Centofanti et al. (2023) \doi{10.1093/jrsssc/qlad074}. It allows testing mean differences among groups of functional data by being robust against the presence of outliers.
}
\details{
\tabular{ll}{
Package: \tab rofanova\cr
Type: \tab Package\cr
Version: \tab 1.0.1 \cr
Date: \tab  2025-12-27 \cr
License: \tab GPL-3\cr
}
}
\examples{
library(rofanova)
data_out<-simulate_data(scenario="one-way")
label_1=data_out$label_1
X_fdata<-data_out$X_fdata
B=10
cores=1
per_list_median<-rofanova(X_fdata,label_1,B = B,family="median",cores=cores)
pvalue_median_vec<-per_list_median$pval_vec
per_list_huber<-rofanova(X_fdata,label_1,B = B,family="huber",cores=cores)
pvalue_huber_vec<-per_list_huber$pval_vec
per_list_bisquare<-rofanova(X_fdata,label_1,B = B,family="bisquare",cores=cores)
pvalue_bisquare_vec<-per_list_bisquare$pval_vec
per_list_hampel<-rofanova(X_fdata,label_1,B = B,family="hampel",cores=cores)
pvalue_hampel_vec<-per_list_hampel$pval_vec
per_list_optimal<-rofanova(X_fdata,label_1,B = B,family="optimal",cores=cores)
pvalue_optimal<-per_list_optimal$pval
}
\references{
Centofanti, F., Colosimo, B. M., Grasso, M. L., Menafoglio, A., Palumbo, B., & Vantini, S. (2023).
Robust functional ANOVA with application to additive manufacturing.
\emph{Journal of the Royal Statistical Society Series C: Applied Statistics}, 72(5), 1210-1234.
}
\seealso{
\code{\link{rofanova}} \code{\link{fusem}} \code{\link{funmad}}
}
\author{
Fabio Centofanti
}
