% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heter.density.plots_function.R
\name{heter_density_plot}
\alias{heter_density_plot}
\title{Visualising the density of two prior distributions for the heterogeneity parameter}
\usage{
heter_density_plot(
  distr,
  heter_prior1,
  heter_prior2,
  heter1 = "tau",
  heter2 = "tau",
  caption = FALSE,
  x_axis_name = TRUE,
  y_axis_name = TRUE,
  title_name = NULL,
  axis_title_size = 13,
  axis_text_size = 13,
  legend_title_size = 13,
  legend_text_size = 13
)
}
\arguments{
\item{distr}{Character string indicating the prior distribution.
Set \code{distr} equal to one of the following: \code{"lognormal"},
\code{"logt"}, or \code{"halfnormal"}, which refers to a log-normal,
location-scale, or half-normal distribution, respectively.}

\item{heter_prior1}{A numeric vector with two values for the first prior
distribution: 1) the mean value and 2) the standard deviation. When
\code{distr = "halfnormal"}, the first value should zero and the second a
non-negative value referring to the scale parameter of the distribution.}

\item{heter_prior2}{A numeric vector with two values for the second prior
distribution: 1) the mean value and 2) the standard deviation. When
\code{distr = "halfnormal"}, the first value should zero and the second a
non-negative value referring to the scale parameter of the distribution.}

\item{heter1}{Character string indicating the heterogeneity parameter
for \code{heter_prior1}. Set \code{heter1} equal to one of the following:
\code{"tau"}, or \code{"tau_omega"}, which refers to a between-study
heterogeneity or between-design heterogeneity (inconsistency),
respectively. This argument is relevant only when
\code{distr = "lognormal"} or \code{distr = "logt"}. The default is
\code{"tau"}.}

\item{heter2}{Character string indicating the heterogeneity parameter
for \code{heter_prior2}. Set \code{heter2} equal to one of the following:
\code{"tau"}, or \code{"tau_omega"}, which refers to a between-study
heterogeneity or between-design heterogeneity (inconsistency),
respectively. This argument is relevant only when
\code{distr = "lognormal"} or \code{distr = "logt"}. The default is
\code{"tau"}.}

\item{caption}{Logical to indicate whether to report a caption at the bottom
right of the plot. It is relevant only when \code{distr = "lognormal"} and
\code{distr = "logt"}. The default is \code{FALSE} (do not report).}

\item{x_axis_name}{Logical to indicate whether to present the title of x-axis
('Between-study standard deviation'). The default is \code{TRUE} (report).}

\item{y_axis_name}{Logical to indicate whether to present the title of y-axis
('Density'). The default is \code{TRUE} (report).}

\item{title_name}{Text for the title of the plot. \code{title_name}
determines the labs argument of the R-package
\href{https://CRAN.R-project.org/package=ggplot2}{ggplot2}.}

\item{axis_title_size}{A positive integer for the font size of axis title.
\code{axis_title_size} determines the axis.title argument found in the
theme's properties in the R-package
\href{https://CRAN.R-project.org/package=ggplot2}{ggplot2}.
The default option is 13.}

\item{axis_text_size}{A positive integer for the font size of axis text.
\code{axis_text_size} determines the axis.text argument found in the
theme's properties in the R-package
\href{https://CRAN.R-project.org/package=ggplot2}{ggplot2}.
The default option is 13.}

\item{legend_title_size}{A positive integer for the font size of legend
title. \code{legend_text_size} determines the legend.text argument found in
the theme's properties in the R-package
\href{https://CRAN.R-project.org/package=ggplot2}{ggplot2}.
The default option is 13.}

\item{legend_text_size}{A positive integer for the font size of legend text.
\code{legend_text_size} determines the legend.text argument found in the
theme's properties in the R-package
\href{https://CRAN.R-project.org/package=ggplot2}{ggplot2}.
The default option is 13.}
}
\value{
A plot with the density of two selected prior distributions for the
heterogeneity parameter. Two different colours are used to discern the
distributions. A legend is also created with the name and hyper-parameters of
the selected prior distributions. The filled area under each curved indicates
the values up to the median of the corresponding distribution. The x-axis
present the 0.1%, 50%, 99% percentile of each distribution.

\code{heter_density_plot} also returns a table with the percentiles of each
distribution.
}
\description{
Creating the density plot of two prior distributions for the between-study
variance (log-normal and location-scale t distributions) or between-study
standard deviation (half-normal distribution).
}
\details{
Use this function to inspect the shape of the distribution and the range of
between-study variance or standard deviation values before you define the
argument \code{heter_prior} in \code{\link{run_model}}) to run random-effects
network meta-analysis.

Turner et al. (2012), Turner et al. (2015), and Rhodes et al. (2016) provide
predictive prior distributions for the between-study variance for a binary
outcome, measured in the log-odds ratio scale, and a continuous outcome,
measured in the standardised mean difference scale, respectively.
}
\examples{

\dontrun{
## Two empirical priors for between-study variance of log odds ratio.
heter_density_plot(distr = "lognormal",
                   heter_prior1 = c(-2.56, 1.74),  # General healthcare setting
                   heter_prior2 = c(-1.83, 1.52))  # Pain and pharma vs. placebo/ctrl

## Two empirical priors for between-study variance of standardised mean
## difference.
heter_density_plot(distr = "logt",
                   heter_prior1 = c(-3.44, 2.59),  # General healthcare setting
                   heter_prior2 = c(-0.60, 2.61))  # Pain and pharma vs. placebo/ctrl for cancer

## Two half-normal prior distributions for between-study standard deviation
heter_density_plot(distr = "halfnormal",
                   heter_prior1 = c(0, 1),
                   heter_prior2 = c(0, 0.5))
}

}
\references{
Rhodes KM, Turner RM, Higgins JP. Predictive distributions were developed
for the extent of heterogeneity in meta-analyses of continuous outcome data.
\emph{J Clin Epidemiol} 2015;\bold{68}(1):52--60.
doi: 10.1016/j.jclinepi.2014.08.012

Turner RM, Jackson D, Wei Y, Thompson SG, Higgins JP. Predictive
distributions for between-study heterogeneity and simple methods for their
application in Bayesian meta-analysis.
\emph{Stat Med} 2015;\bold{34}(6):984--98. doi: 10.1002/sim.6381

Turner RM, Davey J, Clarke MJ, Thompson SG, Higgins JP. Predicting the extent
of heterogeneity in meta-analysis, using empirical data from the Cochrane
Database of Systematic Reviews.
\emph{Int J Epidemiol} 2012;\bold{41}(3):818--27. doi: 10.1093/ije/dys041
}
\seealso{
\code{\link{run_model}}
}
\author{
{Loukia M. Spineli}
}
