% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{cluster}
\alias{cluster}
\title{Cluster Terms from Enrichment Results}
\usage{
cluster(
  enrichment_results,
  df_names = NULL,
  min_terms = 5,
  min_value = 0.1,
  distance_metric = "kappa",
  distance_cutoff = 0.5,
  linkage_method = "average",
  linkage_cutoff = 0.5
)
}
\arguments{
\item{enrichment_results}{A list of dataframes, each containing enrichment results.
Each dataframe should include at least the columns 'Term', 'GeneID', and 'Padj'.}

\item{df_names}{Optional, a character vector of names for the enrichment result dataframes. Must
match the length of `enrichment_results`. Default is `NULL`.}

\item{min_terms}{Minimum number of terms each final cluster must include}

\item{min_value}{Minimum 'Pvalue' a term must have in order to be counted in final clustering}

\item{distance_metric}{A string specifying the distance metric to use (e.g., "kappa").}

\item{distance_cutoff}{A numeric value for the distance cutoff (0 < cutoff <= 1).}

\item{linkage_method}{A string specifying the linkage method to use
(e.g., "average"). Supported options are "single", "complete",
"average", and "ward".}

\item{linkage_cutoff}{A numeric value between 0 and 1 for the membership cutoff.}
}
\value{
A named list containing:
        - `distance_matrix`: The distance matrix used in clustering.
        - `clusters`: The final clusters.
        - `df_list`: The original list of enrichment result dataframes.
        - `merged_df`: The merged dataframe containing combined results.
        - `cluster_options`: A list of clustering parameters used in the analysis.
        - `df_names` (optional): The names of the input dataframes if provided.
}
\description{
This function performs clustering on enrichment results by integrating
gene similarity scores and various clustering strategies.
}
