% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_mc_ik.R
\name{gen_mc_ik}
\alias{gen_mc_ik}
\title{Generate Monte Carlo simulations of Imbens and Kalyanaraman}
\usage{
gen_mc_ik(
  n = 200,
  version = 1,
  sd = 0.1295,
  output = c("data.frame", "rdd_data"),
  size
)
}
\arguments{
\item{n}{The size of sampel to generate}

\item{version}{The MC version of Imbens and Kalnayaraman (between 1 and 4).}

\item{sd}{The standard deviation of the error term.}

\item{output}{Whether to return a data-frame, or already a rdd_data}

\item{size}{The size of the effect, this depends on the specific version, defaults are as in ik: 0.04, NULL, 0.1, 0.1}
}
\value{
An data frame with x and y variables.
}
\description{
Generate the simulations reported in Imbens and Kalyanaraman (2012)
}
\examples{
mc1_dat <- gen_mc_ik()
MC1_rdd <- rdd_data(y=mc1_dat$y, x=mc1_dat$x, cutpoint=0)

## Use np regression:
reg_nonpara <- rdd_reg_np(rdd_object=MC1_rdd)
reg_nonpara

# Represent the curves:
plotCu <- function(version=1, xlim=c(-0.1,0.1)){
  res <- gen_mc_ik(sd=0.0000001, n=1000, version=version)
  res <- res[order(res$x),]
  ylim <- range(subset(res, x>=min(xlim) & x<=max(xlim), 'y'))
  plot(res, type='l', xlim=xlim, ylim=ylim, main=paste('DGP', version))
  abline(v=0)
  xCut <- res[which(res$x==min(res$x[res$x>=0]))+c(0,-1),]
  points(xCut, col=2)
}
layout(matrix(1:4,2, byrow=TRUE))
plotCu(version=1)
plotCu(version=2)
plotCu(version=3)
plotCu(version=4)
layout(matrix(1))
}
