% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/materials.R
\name{hair}
\alias{hair}
\title{Hair Material}
\usage{
hair(
  pigment = 1.3,
  red_pigment = 0,
  color = NA,
  sigma_a = NA,
  eta = 1.55,
  beta_m = 0.3,
  beta_n = 0.3,
  alpha = 2
)
}
\arguments{
\item{pigment}{Default `1.3`. Concentration of the eumelanin pigment in the hair. Blonde hair has concentrations around 0.3, brown around 1.3, and black around 8.}

\item{red_pigment}{Default `0`.Concentration of the pheomelanin pigment in the hair. Pheomelanin makes red hair red.}

\item{color}{Default `NA`. Approximate color. Overrides `pigment`/`redness` arguments.}

\item{sigma_a}{Default `NA`. Attenuation. Overrides `color` and `pigment`/`redness` arguments.}

\item{eta}{Default `1.55`. Index of refraction of the hair medium.}

\item{beta_m}{Default `0.3`. Longitudinal roughness of the hair. Should be between 0 and 1. This roughness controls the size and shape of the hair highlight.}

\item{beta_n}{Default `0.3`. Azimuthal roughness of the hair. Should be between 0 and 1.}

\item{alpha}{Default `2`. Angle of scales on the hair surface, in degrees.}
}
\value{
Single row of a tibble describing the hair material.
}
\description{
Hair Material
}
\examples{
#Create a hairball
if(run_documentation()) {
#Generate rendom points on a sphere
lengthval = 0.5
theta = acos(2*runif(10000)-1.0);
phi = 2*pi*(runif(10000))
bezier_list = list()

#Grow the hairs
for(i in 1:length(phi)) {
  pointval = c(sin(theta[i]) * sin(phi[i]),
               cos(theta[i]),
               sin(theta[i]) * cos(phi[i]))
  bezier_list[[i]] = bezier_curve(width=0.01, width_end=0.008,
                                  p1 = pointval,
                                  p2 = (1+(lengthval*0.33))*pointval, 
                                  p3 = (1+(lengthval*0.66))*pointval,
                                  p4 = (1+(lengthval)) * pointval,
                                  material=hair(pigment = 0.3, red_pigment = 1.3,
                                                beta_m = 0.3, beta_n= 0.3),
                                  type="flat")
}
hairball = dplyr::bind_rows(bezier_list)

generate_ground(depth=-2,material=diffuse(color="grey20")) \%>\%
  add_object(sphere()) \%>\%
  add_object(hairball) \%>\%
  add_object(sphere(y=20,z=20,radius=5,material=light(color="white",intensity = 100))) \%>\%
  render_scene(samples=16, lookfrom=c(0,3,10),clamp_value = 10,
               fov=20, width=800, height=800)
}
if(run_documentation()) {         
               
#Specify the color directly and increase hair roughness
for(i in 1:length(phi)) {
  pointval = c(sin(theta[i]) * sin(phi[i]),
               cos(theta[i]),
               sin(theta[i]) * cos(phi[i]))
  bezier_list[[i]] = bezier_curve(width=0.01, width_end=0.008,
                                  p1 = pointval,
                                  p2 = (1+(lengthval*0.33))*pointval, 
                                  p3 = (1+(lengthval*0.66))*pointval,
                                  p4 = (1+(lengthval)) * pointval,
                                  material=hair(color="purple",
                                                beta_m = 0.5, beta_n= 0.5),
                                  type="flat")
}
hairball = dplyr::bind_rows(bezier_list)
generate_ground(depth=-2,material=diffuse(color="grey20")) \%>\%
  add_object(sphere()) \%>\%
  add_object(hairball) \%>\%
  add_object(sphere(y=20,z=20,radius=5,material=light(color="white",intensity = 100))) \%>\%
  render_scene(samples=16, lookfrom=c(0,3,10),clamp_value = 10,
               fov=20, width=800, height=800)
}
}
