% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circleRANSAC.R
\name{circleRANSAC}
\alias{circleRANSAC}
\title{Adaptive RANSAC Circle Fitting}
\usage{
circleRANSAC(
  cloud,
  fpoints,
  pconf,
  poutlier,
  max_iterations,
  threads = 1L,
  plot = TRUE
)
}
\arguments{
\item{cloud}{A \code{data.table} with *XY* coordinates in the first two columns.}

\item{fpoints}{A \code{numeric} vector between 0 and 1 representing the fraction of point samples that will be used during each iteration.}

\item{pconf}{A \code{numeric} vector between 0 and 1 describing the confidence threshold to consider a point in a given fitted circle outlier or inlier.}

\item{poutlier}{A \code{numeric} vector of length two describing the proportion of outliers to consider inside or outsite of the \code{pconf} threshold.}

\item{max_iterations}{An \code{integer} specifying the number of iterations. If \code{NULL}, the number of iterations are automaticaly estimated using \code{pconf}, \code{1 - poutlier}, and  \code{1 - fpoints}; see details.}

\item{threads}{An \code{integer} specifying the number of threads to use for parallel processing. Experiment to see what works best for your data on your hardware.}

\item{plot}{Logical. If \code{TRUE}, it provides visual representation of the fitted circle.}
}
\value{
A \code{data.table} with the *XY* coordinate information of the circle center, the radius, the error based on the least squares fit, and the proportion of inliers.
}
\description{
Adaptive random sample consensus for cicle fitting.
}
\examples{

#Point cloud
data("pc_tree")

#Subset region at at breast height
sub <- pc_tree[between(Z, 1.25, 1.35),]

#Fit circle
circleRANSAC(sub, fpoints = 0.2, pconf = 0.95, poutlier = c(0.5, 0.5), max_iterations = 100)

}
\seealso{
\code{\link{tree_metrics}}, \code{\link{trunk_volume}}
}
\author{
J. Antonio Guzmán Q.
}
