% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_alpha_cv.R
\name{optimal_alpha_cv}
\alias{optimal_alpha_cv}
\title{The optimal alpha for rSDR via cross-validation}
\usage{
optimal_alpha_cv(alpha.v,X,Y,d,kfolds=10,maxiter=1000,tol=1e-7)
}
\arguments{
\item{alpha.v}{user-supplied alpha sequence. The default is alpha.v=c(0.3,0.4,0.5,0.6,0.7).}

\item{X}{an \eqn{n \times p} numeric matrix, where \eqn{n} is the number of observations and \eqn{p} is the number of variable.}

\item{Y}{an \eqn{n \times k} numeric response matrix, where \eqn{k (\geq 1)} is the number of response variables.}

\item{d}{the number of reduced dimension. The default is d=3.}

\item{kfolds}{the number of folds - default is 10.}

\item{maxiter}{maxiter is the maximum number of iterations allowed for the solver (a non-negative integer). See the Max_Iteration parameter in \code{\link[ManifoldOptim]{get.solver.params}} for details.}

\item{tol}{tol is used to assess convergence, see the Tolerance parameter in \code{\link[ManifoldOptim]{get.solver.params}} for details.}
}
\value{
An object of class "optimal_alpha_cv" is returned. The returned value contains the following components:
\describe{
\item{opt.alpha}{value of alpha that gives minimum f_test.meam.}
\item{f_test.mean}{The mean of cost value by the alpha sequence - a vector of length length(alpha.v).}
\item{f_test.sd}{The standard deviation of cost value by the alpha sequence - a vector of length length(alpha.v).}
\item{f_test}{A kfolds \eqn{\times} length(alpha.v) matrix. The cost value for each fold at a given alpha.}
\item{d}{The value of d as passed to optimal_alpha_cv.}
\item{kfolds}{The value of kfolds as passed to optimal_alpha_cv.}
}
}
\description{
Performs k-folds cross-validation for rSDR method and returns the corresponding optimal alpha.
}
\examples{
library(ManifoldOptim)
library(rSDR)
library(future)
library(future.apply)
utils::data("ionosphere", package = "fdm2id")
X<-as.matrix(ionosphere[,c(1:33)])
Y<-ifelse(ionosphere[,34]=='b',0,1)
Y<-matrix(Y,length(Y),1)
set.seed(2435)
# plan(multisession) will launch parallel workers running in the background
# to save running time. To shut down background workers launched this way, call
# plan(sequential)
# use all local cores except one
# future::plan(future::multisession, workers = future::availableCores() - 1)
# use 2 cores for parallel
\donttest{
future::plan("multisession", workers = 2)
opt_results<-optimal_alpha_cv(alpha.v=c(0.3, 0.5, 0.7),X=X,Y=Y,d=3,kfolds=5)
opt_results
}
}
