% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataFrameSource.R
\name{DataFrameSource}
\alias{DataFrameSource}
\title{Data Frame Source}
\description{
A DataSource implementation that wraps a data frame using DuckDB or SQLite
for SQL query execution.
}
\details{
This class creates an in-memory database connection and registers the
provided data frame as a table. All SQL queries are executed against this
database table. See \link{DBISource} for the full description of available
methods.

By default, DataFrameSource uses the first available engine from duckdb
(checked first) or RSQLite. You can explicitly set the \code{engine} parameter to
choose between \code{"duckdb"} or \code{"sqlite"}, or set the global option
\code{querychat.DataFrameSource.engine} to choose the default engine for all
DataFrameSource instances. At least one of these packages must be installed.
}
\examples{
\dontshow{if (rlang::is_installed("duckdb") || rlang::is_installed("RSQLite")) withAutoprint(\{ # examplesIf}
# Create a data frame source (uses first available: duckdb or sqlite)
df_source <- DataFrameSource$new(mtcars, "mtcars")

# Get database type
df_source$get_db_type()  # Returns "DuckDB" or "SQLite"

# Execute a query
result <- df_source$execute_query("SELECT * FROM mtcars WHERE mpg > 25")

# Explicitly choose an engine
df_sqlite <- DataFrameSource$new(mtcars, "mtcars", engine = "sqlite")

# Clean up when done
df_source$cleanup()
df_sqlite$cleanup()
\dontshow{\}) # examplesIf}
}
\section{Super classes}{
\code{\link[querychat:DataSource]{querychat::DataSource}} -> \code{\link[querychat:DBISource]{querychat::DBISource}} -> \code{DataFrameSource}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DataFrameSource-new}{\code{DataFrameSource$new()}}
\item \href{#method-DataFrameSource-clone}{\code{DataFrameSource$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="querychat" data-topic="DBISource" data-id="cleanup"><a href='../../querychat/html/DBISource.html#method-DBISource-cleanup'><code>querychat::DBISource$cleanup()</code></a></span></li>
<li><span class="pkg-link" data-pkg="querychat" data-topic="DBISource" data-id="execute_query"><a href='../../querychat/html/DBISource.html#method-DBISource-execute_query'><code>querychat::DBISource$execute_query()</code></a></span></li>
<li><span class="pkg-link" data-pkg="querychat" data-topic="DBISource" data-id="get_data"><a href='../../querychat/html/DBISource.html#method-DBISource-get_data'><code>querychat::DBISource$get_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="querychat" data-topic="DBISource" data-id="get_db_type"><a href='../../querychat/html/DBISource.html#method-DBISource-get_db_type'><code>querychat::DBISource$get_db_type()</code></a></span></li>
<li><span class="pkg-link" data-pkg="querychat" data-topic="DBISource" data-id="get_schema"><a href='../../querychat/html/DBISource.html#method-DBISource-get_schema'><code>querychat::DBISource$get_schema()</code></a></span></li>
<li><span class="pkg-link" data-pkg="querychat" data-topic="DBISource" data-id="test_query"><a href='../../querychat/html/DBISource.html#method-DBISource-test_query'><code>querychat::DBISource$test_query()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataFrameSource-new"></a>}}
\if{latex}{\out{\hypertarget{method-DataFrameSource-new}{}}}
\subsection{Method \code{new()}}{
Create a new DataFrameSource
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataFrameSource$new(
  df,
  table_name,
  engine = getOption("querychat.DataFrameSource.engine", NULL)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{df}}{A data frame.}

\item{\code{table_name}}{Name to use for the table in SQL queries. Must be a
valid table name (start with letter, contain only letters, numbers,
and underscores)}

\item{\code{engine}}{Database engine to use: "duckdb" or "sqlite". Set the
global option \code{querychat.DataFrameSource.engine} to specify the default
engine for all instances. If NULL (default), uses the first available
engine from duckdb or RSQLite (in that order).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new DataFrameSource object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataFrameSource-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DataFrameSource-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataFrameSource$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
