% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcoint.R
\name{pcoint}
\alias{pcoint}
\alias{pcoint.JO}
\alias{pcoint.BR}
\alias{pcoint.SL}
\alias{pcoint.CAIN}
\title{Panel cointegration rank tests}
\usage{
pcoint.JO(
  L.data,
  lags,
  type = c("Case1", "Case2", "Case3", "Case4"),
  t_D1 = NULL,
  t_D2 = NULL,
  n.factors = FALSE
)

pcoint.BR(
  L.data,
  lags,
  type = c("Case1", "Case2", "Case3", "Case4"),
  t_D1 = NULL,
  t_D2 = NULL,
  n.iterations = FALSE
)

pcoint.SL(L.data, lags, type = "SL_trend", t_D = NULL, n.factors = FALSE)

pcoint.CAIN(L.data, lags, type = "SL_trend", t_D = NULL)
}
\arguments{
\item{L.data}{List of '\code{data.frame}' objects for each individual. 
The variables must have the same succession \eqn{k = 1,\ldots,K} 
in each individual '\code{data.frame}'.}

\item{lags}{Integer or vector of integers. 
Lag-order of the VAR models in levels, which is
either a common \eqn{p} for all individuals or 
individual-specific \eqn{p_i} for each individual.  
In the vector, \eqn{p_i} must have the same succession 
\eqn{i = 1,\ldots,N} as argument \code{L.data}.}

\item{type}{Character. The conventional case of the \link[=as.t_D]{deterministic term}.}

\item{t_D1}{List of vectors. The activating break periods \eqn{\tau} 
for the period-specific \link[=as.t_D]{deterministic regressors} in \eqn{d_{1,it}}, 
which are restricted to the cointegration relations. 
The accompanying lagged regressors are automatically included in \eqn{d_{2,it}}. 
The \eqn{p}-values are calculated for up to two breaks resp. three sub-samples.}

\item{t_D2}{List of vectors. The activating break periods \eqn{\tau} 
for the period-specific \link[=as.t_D]{deterministic regressors} in \eqn{d_{2,it}}, 
which are unrestricted.}

\item{n.factors}{Integer. Number of common factors to be subtracted 
for the PANIC by Arsova and Oersal (2017, 2018). 
Deactivated if \code{FALSE} (the default).}

\item{n.iterations}{Integer. The (maximum) number of iterations for the 
pooled estimation of the cointegrating vectors.}

\item{t_D}{List of vectors. The activating break periods \eqn{\tau} 
for the period-specific \link[=as.t_D]{deterministic regressors} in \eqn{d_{it}} 
of the SL-procedure. 
The accompanying lagged regressors are automatically included in \eqn{d_{it}}. 
The \eqn{p}-values are calculated for up to two breaks resp. three sub-samples.}
}
\value{
A list of class '\code{pcoint}' with elements:
\item{panel}{List for the panel test results, 
  which contains one matrix for the test statistics and one for the \eqn{p}-values.}
\item{individual}{List for the individual test results, 
  which contains one matrix for the test statistics and one for the \eqn{p}-values.}
\item{CSD}{List of measures for cross-sectional dependency. 
  \code{NULL} if a first generation test has been used.}
\item{args_pcoint}{List of characters and integers 
  indicating the panel cointegration test and specifications that have been used.}
\item{beta_H0}{List of matrices, 
  which comprise the pooled cointegrating vectors for each rank \eqn{r_{H0}}. 
\code{NULL} if any other test than \code{BR} has been used.}
}
\description{
Performs test procedures for the rank of cointegration in a panel of VAR models.
  First, the chosen individual procedure is applied over 
  all \eqn{N} individual entities for \eqn{r_{H0}=0,\ldots,K-1}. 
  Then, the \eqn{K \times N} individual statistics and \eqn{p}-values 
  are combined to panel test results on each \eqn{r_{H0}}
  using all combination approaches available for the chosen procedure.
}
\section{Functions}{
\itemize{
\item \code{pcoint.JO()}: based on the Johansen procedure.

\item \code{pcoint.BR()}: based on the pooled two-step estimation of the cointegrating vectors.

\item \code{pcoint.SL()}: based on the Saikkonen-Luetkepohl procedure.

\item \code{pcoint.CAIN()}: accounting for correlated probits between the individual SL-procedures.

}}
\examples{
### reproduce Oersal,Arsova 2017:67, Ch.5 ###
data("MERM")
names_k = colnames(MERM)[-(1:2)] # variable names
names_i = levels(MERM$id_i)      # country names
L.data  = sapply(names_i, FUN=function(i) 
   ts(MERM[MERM$id_i==i, names_k], start=c(1995, 1), frequency=12), 
   simplify=FALSE)

# Oersal,Arsova 2017:67, Tab.5 #
R.lags = c(2, 2, 2, 2, 1, 2, 2, 4, 2, 3, 2, 2, 2, 2, 2, 1, 1, 2, 2)
names(R.lags) = names_i  # individual lags by AIC (lag_max=4)
n.factors = 8  # number of common factors by Onatski's (2010) criterion
R.pcsl = pcoint.SL(L.data, lags=R.lags, n.factors=n.factors, type="SL_trend")
R.pcjo = pcoint.JO(L.data, lags=R.lags, n.factors=n.factors, type="Case4")

# Oersal,Arsova 2017:67, Tab.6 #
R.Ftsl = coint.SL(y=R.pcsl$CSD$Ft, dim_p=2, type_SL="SL_trend")  # lag-order by AIC
R.Ftjo = coint.JO(y=R.pcsl$CSD$Ft, dim_p=2, type="Case4")

### reproduce Oersal,Arsova 2016:13, Ch.6 ###
data("ERPT")
names_k = c("lpm5", "lfp5", "llcusd")  # variable names for "Chemicals and related products"
names_i = levels(ERPT$id_i)[c(1,6,2,5,4,3,7)]  # ordered country names
L.data  = sapply(names_i, FUN=function(i) 
   ts(ERPT[ERPT$id_i==i, names_k], start=c(1995, 1), frequency=12), 
   simplify=FALSE)

# Oersal,Arsova 2016:21, Tab.6 (only for individual results) #
R.lags = c(3, 3, 3, 4, 3, 3, 3); names(R.lags)=names_i  # lags of VAR model by MAIC
R.cain = pcoint.CAIN(L.data, lags=R.lags, type="SL_trend")
R.pcsl = pcoint.SL(L.data,   lags=R.lags, type="SL_trend")

# Oersal,Arsova 2016:22, Tab.7/8 #
R.lags = c(3, 3, 3, 4, 4, 3, 4); names(R.lags)=names_i  # lags of VAR model by MAIC
R.t_D  = list(t_break=89)  # a level shift and trend break in 2002_May for all countries
R.cain = pcoint.CAIN(L.data, lags=R.lags, t_D=R.t_D, type="SL_trend")

}
\references{
Larsson, R., Lyhagen, J., and Lothgren, M. (2001): 
  "Likelihood-based Cointegration Tests in Heterogeneous Panels",
  \emph{Econometrics Journal}, 4, pp. 109-142.

Choi, I. (2001): 
  "Unit Root Tests for Panel Data", 
  \emph{Journal of International Money and Finance}, 20, pp. 249-272.

Arsova, A., and Oersal, D. D. K. (2018): 
  "Likelihood-based Panel Cointegration Test in the Presence of 
  a Linear Time Trend and Cross-Sectional Dependence", 
  \emph{Econometric Reviews}, 37, pp. 1033-1050.

Breitung, J. (2005): 
  "A Parametric Approach to the Estimation of Cointegration Vectors in Panel Data",
  \emph{Econometric Reviews}, 24, pp. 151-173.

Oersal, D. D. K., and Droge, B. (2014): 
  "Panel Cointegration Testing in the Presence of a Time Trend", 
  \emph{Computational Statistics & Data Analysis}, 76, pp. 377-390.

Oersal, D. D. K., and Arsova, A. (2017): 
  "Meta-Analytic Cointegrating Rank Tests for Dependent Panels", 
  \emph{Econometrics and Statistics}, 2, pp. 61-72.

Arsova, A., and Oersal, D. D. K. (2018): 
  "Likelihood-based Panel Cointegration Test in the Presence of 
  a Linear Time Trend and Cross-Sectional Dependence", 
  \emph{Econometric Reviews}, 37, pp. 1033-1050.

Hartung, J. (1999):
  "A Note on Combining Dependent Tests of Significance",
  \emph{Biometrical Journal}, 41, pp. 849-855.

Arsova, A., and Oersal, D. D. K. (2021): 
  "A Panel Cointegrating Rank Test with Structural Breaks and Cross-Sectional Dependence", 
  \emph{Econometrics and Statistics}, 17, pp. 107-129.
}
\concept{panel cointegration rank tests}
