% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bar_plot.R
\name{plot_bar}
\alias{plot_bar}
\title{Bar Plot for Categorical Data with Optional Grouping}
\usage{
plot_bar(
  data,
  var,
  by = NULL,
  vjust = -0.3,
  hjust = 0.5,
  axis.label.angle = 45,
  label = NULL,
  border.color = NULL,
  label.color = "black",
  x.lab = "Group",
  y.lab = "Percentage (\%)",
  fill.lab = "Variable",
  text.size = 3,
  color.bar = NULL,
  theme_fun = ggthemes::theme_stata,
  bar.width = 0.8,
  y.expand = 1.12
)
}
\arguments{
\item{data}{A data frame containing the variables to plot.}

\item{var}{The main categorical variable to display on the x-axis (unquoted or quoted).}

\item{by}{Optional grouping variable for stacked/dodged bars (unquoted or quoted). Default is NULL.}

\item{vjust}{Vertical adjustment for text labels. Default is -0.3.}

\item{hjust}{Horizontal adjustment for text labels. Default is 0.5.}

\item{axis.label.angle}{Angle of x-axis labels. Default is 45.}

\item{label}{Optional custom labels for factor levels of \code{var}.}

\item{border.color}{Optional color for bar borders. Default is NULL.}

\item{label.color}{Color of the text labels on bars. Default is "black".}

\item{x.lab}{Label for x-axis. Default is "Group".}

\item{y.lab}{Label for y-axis. Default is "Percentage (\%)".}

\item{fill.lab}{Legend title for the fill variable. Default is "Variable".}

\item{text.size}{Size of the text labels. Default is 3.}

\item{color.bar}{Optional vector of colors for bars.}

\item{theme_fun}{Theme function from ggthemes (or ggplot2) for styling. Default is \code{ggthemes::theme_stata}.}

\item{bar.width}{Width of the bars. Default is 0.8.}

\item{y.expand}{Factor to expand the y-axis for space above the highest bar. Default is 1.12.}
}
\value{
A \code{ggplot2} object representing the bar plot.
}
\description{
Creates a publication-quality bar plot for a categorical variable, with optional grouping by another variable.
Automatically calculates counts and percentages and can display them on the bars. Also performs Chi-square or Fisher exact test if \code{by} is provided.
}
\examples{
# Example using CO2 dataset
plot_bar(
  CO2,
  var = "Type",
  by = "Treatment",
  fill.lab = "Plant Type",
  color.bar = c("lightblue","lightgreen"),
  border.color = "black",
  bar.width = 0.5,
  text.size = 3,
  label = c("Quebec","Mississippi")
)

# Example using diamonds dataset
plot_bar(
  ggplot2::diamonds,
  var = "cut",
  by = "color",
  y.lab = "Distribution (\%)",
  fill.lab = "Cut",
  text.size = 2,
  bar.width = 0.9,
  color.bar = c("#a465db","steelblue","darkgreen","darkred","#fcba03")
)

# Simple bar plot without grouping
plot_bar(ggplot2::diamonds, var = "cut")

}
