% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_stats.R
\name{group_stats}
\alias{group_stats}
\title{Get Statistics for All Teams in a League}
\usage{
group_stats(league = NULL, year = NULL, level = NULL, stored = TRUE)
}
\arguments{
\item{league}{A character string specifying which league to retrieve. Must be
"AU", "LOVB" or "MLV".}

\item{year}{A numeric value specifying the year for which to retrieve
statistics. Must be 2024 or later for LOVB or MLV and 2021 or later for AU.}

\item{level}{A character string specifying whether to extract the "team" or individual
"player" statistics. AU has no team statistics.}

\item{stored}{A logical specifying whether to use stored data for previous years
(TRUE is default) or force the function to scrape the website (FALSE)}
}
\value{
A data frame containing statistics for all teams in the specified
league and year(s). The structure depends on the league and level:
\itemize{
\item For MLV team-level: Team match statistics
\item For MLV player-level: Individual player statistics
\item For LOVB team-level: Team match statistics
\item For LOVB player-level: Individual player statistics
}
}
\description{
This function retrieves statistics for all teams in a specified league
(LOVB or MLV) and year(s).
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# Get all team statistics for both leagues
au_team_data <- group_stats(league = "AU", year = 2021:2025)
lovb_team_data <- group_stats(league = "LOVB", year = 2025, level = "team")
lovb_player_data <- group_stats(league = "LOVB", year = 2025, level = "player")
mlv_team_data <- group_stats(league = "MLV", year = 2024:2025, level = "team")
mlv_player_data <- group_stats(league = "MLV", year = 2024:2025, level = "player")
\dontshow{\}) # examplesIf}
}
\seealso{
Other statistics functions: 
\code{\link{au_stats}()},
\code{\link{get_stats}()},
\code{\link{lovb_stats}()},
\code{\link{mlv_stats}()}
}
\concept{statistics functions}
