% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conformal_infer_cv.R, R/conformal_infer_full.R,
%   R/conformal_infer_quantile.R, R/conformal_infer_split.R
\name{predict.int_conformal_cv}
\alias{predict.int_conformal_cv}
\alias{predict.int_conformal_full}
\alias{predict.int_conformal_quantile}
\alias{predict.int_conformal_split}
\title{Prediction intervals from conformal methods}
\usage{
\method{predict}{int_conformal_cv}(object, new_data, level = 0.95, ...)

\method{predict}{int_conformal_full}(object, new_data, level = 0.95, ...)

\method{predict}{int_conformal_quantile}(object, new_data, ...)

\method{predict}{int_conformal_split}(object, new_data, level = 0.95, ...)
}
\arguments{
\item{object}{An object produced by \code{\link[=predict.int_conformal_full]{predict.int_conformal_full()}}.}

\item{new_data}{A data frame of predictors.}

\item{level}{The confidence level for the intervals.}

\item{...}{Not currently used.}
}
\value{
A tibble with columns \code{.pred_lower} and \code{.pred_upper}. If
the computations for the prediction bound fail, a missing value is used. For
objects produced by \code{\link[=int_conformal_cv]{int_conformal_cv()}}, an additional \code{.pred} column
is  also returned (see Details below).
}
\description{
Prediction intervals from conformal methods
}
\details{
For the CV+. estimator produced by \code{\link[=int_conformal_cv]{int_conformal_cv()}}, the intervals
are centered around the mean of the predictions produced by the
resample-specific model. For example, with 10-fold cross-validation, \code{.pred}
is the average of the predictions from the 10 models produced by each fold.
This may differ from the prediction generated from a model fit that was
trained on the entire training set, especially if the training sets are
small.
}
\seealso{
\code{\link[=int_conformal_full]{int_conformal_full()}}, \code{\link[=int_conformal_cv]{int_conformal_cv()}}
}
