% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blowflies.R
\docType{data}
\name{blowflies}
\alias{blowflies}
\alias{blowflies1}
\alias{blowflies2}
\title{Nicholson's blowflies.}
\usage{
blowflies1(
  P = 3.2838,
  delta = 0.16073,
  N0 = 679.94,
  sigma.P = 1.3512,
  sigma.d = 0.74677,
  sigma.y = 0.026649
)

blowflies2(
  P = 2.7319,
  delta = 0.17377,
  N0 = 800.31,
  sigma.P = 1.442,
  sigma.d = 0.76033,
  sigma.y = 0.010846
)
}
\arguments{
\item{P}{reproduction parameter}

\item{delta}{death rate}

\item{N0}{population scale factor}

\item{sigma.P}{intensity of \eqn{e} noise}

\item{sigma.d}{intensity of \eqn{eps} noise}

\item{sigma.y}{measurement error s.d.}
}
\value{
\code{blowflies1} and \code{blowflies2} return \sQuote{pomp} objects containing the actual data and two variants of the model.
}
\description{
\code{blowflies} is a data frame containing the data from several of Nicholson's classic experiments with the Australian sheep blowfly, \emph{Lucilia cuprina}.
}
\details{
\code{blowflies1()} and \code{blowflies2()} construct \sQuote{pomp} objects encoding stochastic delay-difference equation models.
The data for these come from "population I", a control culture.
The experiment is described on pp. 163--4 of Nicholson (1957).
Unlimited quantities of larval food were provided;
the adult food supply (ground liver) was constant at 0.4g per day.
The data were taken from the table provided by Brillinger et al. (1980).

The models are discrete delay equations:
\deqn{R(t+1) \sim \mathrm{Poisson}(P N(t-\tau) \exp{(-N(t-\tau)/N_{0})} e(t+1) {\Delta}t)}{R[t+1] ~ Poisson(P N[t-tau] exp(-N[t-tau]/N0) e[t+1] dt)}
\deqn{S(t+1) \sim \mathrm{Binomial}(N(t),\exp{(-\delta \epsilon(t+1) {\Delta}t)})}{S[t+1] ~ binomial(N[t],exp(-delta eps[t+1] dt))}
\deqn{N(t) = R(t)+S(t)}{N[t]=R[t]+S[t]}
where \eqn{e(t)}{e[t]} and \eqn{\epsilon(t)}{eps[t]} are Gamma-distributed i.i.d. random variables
with mean 1 and variances \eqn{{\sigma_P^2}/{{\Delta}t}}{sigma.P^2/dt}, \eqn{{\sigma_d^2}/{{\Delta}t}}{sigma.d^2/dt}, respectively.
\code{blowflies1} has a timestep (\eqn{{\Delta}t}{dt}) of 1 day; \code{blowflies2} has a timestep of 2 days.
The process model in \code{blowflies1} thus corresponds exactly to that studied by Wood (2010).
The measurement model in both cases is taken to be
\deqn{y(t) \sim  \mathrm{NegBin}(N(t),1/\sigma_y^2)}{y[t] ~ negbin(N[t],1/sigma.y^2),}
i.e., the observations are assumed to be negative-binomially distributed with
mean \eqn{N(t)}{N[t]} and variance \eqn{N(t)+(\sigma_y N(t))^2}{N[t]+(sigma.y N[t])^2}.

Default parameter values are the MLEs as estimated by Ionides (2011).
}
\examples{

plot(blowflies1())
plot(blowflies2())

}
\references{
\Nicholson1957

\Xia2011

\Ionides2011

\Wood2010

\Gurney1980a

\Brillinger1980
}
\seealso{
More examples provided with \pkg{pomp}:
\code{\link{childhood_disease_data}},
\code{\link{compartmental_models}},
\code{\link{dacca}()},
\code{\link{ebola}},
\code{\link{gompertz}()},
\code{\link{ou2}()},
\code{\link{pomp_examples}},
\code{\link{ricker}()},
\code{\link{rw2}()},
\code{\link{verhulst}()}

More data sets provided with \pkg{pomp}:
\code{\link{bsflu}},
\code{\link{childhood_disease_data}},
\code{\link{dacca}()},
\code{\link{ebola}},
\code{\link{parus}}
}
\concept{pomp datasets}
\concept{pomp examples}
\keyword{models}
