% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poi.R
\name{poi}
\alias{poi}
\title{Pole of Inaccessibility (Visual Center) of a Polygon}
\source{
Garcia-Castellanos & Lombardo, 2007. Poles of inaccessibility: A
calculation algorithm for the remotest places on earth Scottish
Geographical Journal, Volume 123, 3, 227-233.
\doi{10.1080/14702540801897809}

\url{https://github.com/mapbox/polylabel}

\url{https://blog.mapbox.com/a-new-algorithm-for-finding-a-visual-center-of-a-polygon-7c77e6492fbc}
}
\usage{
poi(x, y = NULL, precision = 1)
}
\arguments{
\item{x}{a vector of x coordinates or a matrix or data.frame
of x and y coordinates, a list of components x and y,
a time series (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}} for details),
or a simple features object from package \code{sf}.}

\item{y}{a vector of y coordinates. Only needs to be provided if
\code{x} is vector.}

\item{precision}{the precision to use when computing the center}
}
\value{
A list with items
\item{\code{x}}{x coordinate of the center}
\item{\code{y}}{y coordinate of the center}
\item{\code{dist}}{distance to the enclosing polygon}
}
\description{
This function computes and returns the approximate
pole of inaccessibility for a polygon using a quadtree-based algorithm
developed by the people from Mapbox.
}
\details{
If there are any \code{NA} values in the input, they
will be treated as separators for multiple paths (rings) of the
polygon, mimicking the behavior of \code{\link[graphics:polypath]{graphics::polypath()}}.
}
\examples{
plot_path <- function(x, y, ...) {
  plot.new()
  plot.window(range(x, na.rm = TRUE), range(y, na.rm = TRUE))
  polypath(x, y, ...)
}

x <- c(5, 10, 10, 5, 5, 6, 6, 7, 7, 6, 8, 8, 9, 9, 8)
y <- c(5, 5, 10, 10, 5, 6, 7, 7, 6, 6, 8, 9, 9, 8, 8)

plot_path(x, y, col = "grey", border = NA)

points(poi(x, y))

\dontrun{
# Find visual centers for North Carolina counties
library(sf)
nc <- st_read(system.file("shape/nc.shp", package = "sf"))
locations <- do.call(rbind, poi(nc, precision = 0.01))
plot(st_geometry(nc))
points(locations)
}
}
\seealso{
\code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}, \code{\link[graphics:polypath]{graphics::polypath()}}
}
