% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplers.R
\name{r_unif_polysph}
\alias{r_unif_polysph}
\title{Sample uniform polyspherical data}
\usage{
r_unif_polysph(n, d)
}
\arguments{
\item{n}{sample size.}

\item{d}{vector of size \code{r} with dimensions.}
}
\value{
A matrix of size \code{c(n, sum(d) + r)} with the sample.
}
\description{
Simulates from a uniform distribution on the polysphere
\eqn{\mathcal{S}^{d_1} \times \cdots \times \mathcal{S}^{d_r}}.
}
\examples{
# Simulate uniform data on (S^1)^2
r_unif_polysph(n = 10, d = c(1, 1))
}
