% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxode2user.R
\name{NN}
\alias{NN}
\title{Neural Network ODE language in nlmixr2 langauage}
\usage{
NN(
  number = 1,
  state = "t",
  min_init = 0.5,
  max_init = 10,
  n_hidden = 5,
  act = c("ReLU", "Softplus"),
  time_nn = FALSE,
  beta = 20,
  pop = getOption("pmxNODE.pop", TRUE),
  eta_model = c("prop", "add"),
  theta_scale = 0.1,
  eta_scale = 0.1,
  pre_fixef = getOption("pmxNODE.pre_fixef", NULL),
  iniDf = NULL
)
}
\arguments{
\item{number}{The neural network number}

\item{state}{The state to be used in the neural network.  For time, use \emph{t}}

\item{min_init}{The minimum value of activation point for the
neural network, (i.e., minimal expected state value)}

\item{max_init}{The maximum value of activation point for the NN
(i.e. maximum expected state value)}

\item{n_hidden}{The number of hidden layers in the neural network (default 5)}

\item{act}{activation in the hidden layer, ReLU and Softplus
implemented. Default is ReLU.}

\item{time_nn}{defines if the neural network is time dependent and
consequently all weights from inputs to hidden layer should be
strictly negative (default is FALSE)}

\item{beta}{(numeric) Beta value for the Softplus activation function, only applicable if \emph{act="Softplus"}; Default to 20.}

\item{pop}{(boolean) If the generated nlmixr model function should
be a fit without (TRUE) or with (FALSE).  Default is FALSE.}

\item{eta_model}{(string)
\itemize{
  \item \dQuote{prop} is of form W = lW * EXP(etaW)
  \item \dQuote{add} is of form W = lW + etaW
}}

\item{theta_scale}{(numeric) Scale in which typical NN parameter values are initialized, default is 0.1, i.e., weights are 
initialized between -0.3 and 0.3}

\item{eta_scale}{(numeric) Initial standard deviation of random effects on NN parameters, default is 0.1}

\item{pre_fixef}{(named vector) Specific initial values for typical parameters, can be obtained from a run nlmixr model (e.g., run_1) through
\emph{run_1$fixef}}

\item{iniDf}{iniDf}
}
\value{
A list with the before and replace elements and iniDf to
  allow integration in the rxode2/nlmixr2 language directly.
}
\description{
Neural Network ODE language in nlmixr2 langauage
}
\examples{
\dontrun{
 if (requireNamespace("rxode2", quietly = TRUE)) {

# Called directly, this isn't that interesting, but can show what
# is produced for rxode2 integration

library(rxode2)

NN(1, state="t", min_init=0.1, max_init=24, pop=TRUE)

# This can be used in the rxode2 language as follows:

f_ode_pop <- function(){
  ini({
    lV <- 1
    prop.err <- 0.1
  })
  model({
    V <- lV
    d/dt(centr)  =  NN(1, state=centr,min_init=0,max_init=300)
    cp = centr / V
    cp ~ prop(prop.err)
  })
}

# but it expands to the complete model:

f_ode_pop()

# This is because pmxNODE uses the extensible user model interface
# in rxode2.  This only works if you load rxode2/nlmixr2 and pmxNODE

}
}
}
\author{
Matthew L Fidler (uses the same functions
  `nn_generator_nlmixr`, written by Dominic Bräm)
}
