% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{checkRemoveIDs}
\alias{checkRemoveIDs}
\title{Check and construct individual IDs to be removed}
\usage{
checkRemoveIDs(prefix, remove_individuals = NULL, keep_individuals)
}
\arguments{
\item{prefix}{[character] Prefix of PLINK files, i.e. path/2/name.bed,
path/2/name.bim and path/2/name.fam.}

\item{remove_individuals}{[character] Path to file with individuals to be
removed from the analysis. The file has to be a space/tab-delimited text file
with family IDs in the first column and within-family IDs in the second
column. All samples listed in this file will be removed from the current
analysis. See \url{https://www.cog-genomics.org/plink/1.9/filter#indiv}.
Default: NULL, i.e. no filtering on individuals.}

\item{keep_individuals}{[character] Path to file with individuals to be
retained in the analysis. The file has to be a space/tab-delimited text file
with family IDs in the first column and within-family IDs in the second
column. All samples not listed in this file will be removed from the current
analysis. See \url{https://www.cog-genomics.org/plink/1.9/filter#indiv}.
Default: NULL, i.e. no filtering on individuals.}
}
\value{
data.frame containing family (FID) and individual (IID) IDs of
individuals to be removed from analysis.
}
\description{
checkRemoveIDs checks that the file names with the individuals to be filtered
can be found. It reads the corresponding files, combines the selected
individuals into one data.frame and compares these to all individuals in
the analysis.
}
