% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match.R
\name{match}
\alias{match}
\title{Build a function for matching pathnames against a pathname specification}
\usage{
match(path, decode = NULL, delimiter = "/", ...)
}
\arguments{
\item{path}{A character vector of length 1. A pathname specification.}

\item{decode}{A function for decoding a string or FALSE to disable it.}

\item{delimiter}{A character vector of length 1. Specifies the delimiter for the path segments.}

\item{...}{Additional parameters for \code{pathToRegexp} or \code{parse}.}
}
\value{
A function.
}
\description{
Build a function for matching pathnames against a pathname specification
}
\examples{

path <- "/users/:userId/books/:bookId/*public"
fn <- match(path)
p <- fn("/users/User1/books/Id1/2/3")
p

path <- "/path/resource"
fn <- match(path)
fn("/resource/path")


}
