% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinates.R
\name{pullCoordsNoCov}
\alias{pullCoordsNoCov}
\title{Generic Loss Function Coordinates}
\usage{
pullCoordsNoCov(df, cov, exp, ...)
}
\arguments{
\item{df}{data frame}

\item{cov}{covariance matrix}

\item{exp}{reference values}

\item{...}{other expected values of getCoords}
}
\value{
matrix with coordinate representation of all points
}
\description{
Coordinates are computed as centered by the reference value and
scaled with the standard deviation.
Uses the i,ith entry of the covariance matrix as the standard deviation of the ith variable.
}
\examples{
head(pullCoordsNoCov(Bikes$space2,cov(Bikes$space2),
                data.frame(value = colMeans(Bikes$space2))))


}
