% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-affiliations.R
\name{orcid_research_resources}
\alias{orcid_research_resources}
\title{Retrieve research resources from ORCID}
\usage{
orcid_research_resources(orcid_id, token = NULL)
}
\arguments{
\item{orcid_id}{Character string. A valid ORCID identifier in the format
XXXX-XXXX-XXXX-XXXX. Can also handle URLs like https://orcid.org/XXXX-XXXX-XXXX-XXXX.}

\item{token}{Character string or NULL. Optional API token for authenticated
requests. If NULL (default), checks the ORCID_TOKEN environment variable.}
}
\value{
A data.table with the following columns:
\describe{
\item{orcid}{ORCID identifier}
\item{put_code}{Unique identifier for this resource record}
\item{title}{Resource title/name}
\item{hosts}{Hosting organizations (comma-separated)}
\item{start_date}{Resource start date (ISO format)}
\item{end_date}{Resource end date (ISO format)}
}
Returns an empty data.table with the same structure if no research
resource records are found.
}
\description{
Fetches research resource records for an ORCID identifier, such as
facilities, equipment, databases, collections, etc.
}
\details{
This function queries the ORCID public API endpoint:
\code{https://pub.orcid.org/v3.0/{orcid-id}/research-resources}

Note: Research resources have a different structure than other affiliations,
with a focus on the resource itself rather than organizational affiliations.
}
\examples{
\dontrun{
# Fetch research resources
resources <- orcid_research_resources("0000-0002-1825-0097")
print(resources)
}

}
\references{
ORCID API Documentation: \url{https://info.orcid.org/documentation/api-tutorials/}
}
\seealso{
\code{\link{orcid_works}}, \code{\link{orcid_activities}}
}
