% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-affiliations.R
\name{orcid_memberships}
\alias{orcid_memberships}
\title{Retrieve memberships from ORCID}
\usage{
orcid_memberships(orcid_id, token = NULL)
}
\arguments{
\item{orcid_id}{Character string. A valid ORCID identifier in the format
XXXX-XXXX-XXXX-XXXX. Can also handle URLs like https://orcid.org/XXXX-XXXX-XXXX-XXXX.}

\item{token}{Character string or NULL. Optional API token for authenticated
requests. If NULL (default), checks the ORCID_TOKEN environment variable.}
}
\value{
A data.table with the following columns:
\describe{
\item{orcid}{ORCID identifier}
\item{put_code}{Unique identifier for this membership record}
\item{organization}{Name of the organization}
\item{department}{Department name (if available)}
\item{role}{Membership role or title}
\item{start_date}{Membership start date (ISO format)}
\item{end_date}{Membership end date (ISO format)}
\item{city}{City of organization}
\item{region}{State/region of organization}
\item{country}{Country of organization}
}
Returns an empty data.table with the same structure if no membership
records are found.
}
\description{
Fetches professional membership records for an ORCID identifier, such as
memberships in professional societies, organizations, etc.
}
\details{
This function queries the ORCID public API endpoint:
\code{https://pub.orcid.org/v3.0/{orcid-id}/memberships}
}
\examples{
\dontrun{
# Fetch memberships
memberships <- orcid_memberships("0000-0002-1825-0097")
print(memberships)
}

}
\references{
ORCID API Documentation: \url{https://info.orcid.org/documentation/api-tutorials/}
}
\seealso{
\code{\link{orcid_employments}}, \code{\link{orcid_activities}}
}
