% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Viz_manipul_main.R
\name{export_annotations}
\alias{export_annotations}
\title{Export annotation data}
\usage{
export_annotations(
  ontology,
  annotations = "auto",
  incl.names = FALSE,
  sep.head = ", ",
  sep.tail = NULL,
  collapse = NULL
)
}
\arguments{
\item{ontology}{Ontology}

\item{annotations}{which annotations to use: "auto" means automatic annotations, "manual" means manual ones.
Alternatively, any othe list element containing annotations can be specified.}

\item{incl.names}{if TRUE includes terms' names and IDs, otherwise includes just IDs.}

\item{sep.head}{if incl.names=TRUE, this is a separator attached to the begining of term's ID}

\item{sep.tail}{if incl.names=TRUE, this is a separator attached to the end of term's ID}

\item{collapse}{if NULL all annotations of a term placed in separate columns, if a value is specified (e.g., "; ") then all anotations
are collapsed in one line given that values}
}
\value{
Returns a table
}
\description{
This function converts character annotations stored in shiny_in object to table format.
}
\examples{
data(Sharkey_2011)
data(HAO)
hao_obo<-onto_process(HAO, Sharkey_2011[,1], do.annot = FALSE)
ontofast <- new.env(parent = emptyenv())
ontofast$shiny_in <- make_shiny_in(hao_obo)
# runOntoFast(is_a = c("is_a"), part_of = c("BFO:0000050"), shiny_in="shiny_in" )
tb<-export_annotations(ontofast$shiny_in, annotations="manual", incl.names=TRUE,collapse="; ")
tb<-export_annotations(ontofast$shiny_in, annotations="auto", incl.names=TRUE,collapse="; ")
tb<-export_annotations(ontofast$shiny_in, annotations="auto", incl.names=TRUE,collapse=NULL)
# save annotations in csv
# write.csv(tb, "annotated_characters.csv")
}
